<?php
require_once 'config.php';

if(!isset($_GET['slug'])) {
    header("Location: yazilar.php");
    exit;
}

$slug = $_GET['slug'];

// Yazıyı getir
$sql = "SELECT * FROM yazilar WHERE slug = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "s", $slug);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$yazi = mysqli_fetch_assoc($result);

if(!$yazi) {
    header("Location: yazilar.php");
    exit;
}

$page_title = $yazi['baslik'] . " - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row">
        <div class="col-lg-8">
            <article>
                <?php if($yazi['resim']): ?>
                <img src="uploads/yazilar/<?php echo $yazi['resim']; ?>" alt="<?php echo $yazi['baslik']; ?>" class="img-fluid rounded mb-4" style="width: 100%; height: 400px; object-fit: cover;">
                <?php endif; ?>

                <header class="mb-4">
                    <h1><?php echo $yazi['baslik']; ?></h1>
                    <div class="text-muted">
                        <i class="fas fa-calendar"></i> <?php echo date('d.m.Y', strtotime($yazi['created_at'])); ?>
                    </div>
                </header>

                <div class="content">
                    <?php echo $yazi['icerik']; ?>
                </div>
            </article>

            <hr class="my-5">

            <!-- Diğer Yazılar -->
            <section>
                <h3>Diğer Yazılar</h3>
                <div class="row">
                    <?php
                    $sql = "SELECT baslik, slug, resim, ozet FROM yazilar WHERE id != ? ORDER BY created_at DESC LIMIT 3";
                    $stmt = mysqli_prepare($conn, $sql);
                    mysqli_stmt_bind_param($stmt, "i", $yazi['id']);
                    mysqli_stmt_execute($stmt);
                    $result = mysqli_stmt_get_result($stmt);
                    while($row = mysqli_fetch_assoc($result)):
                    ?>
                    <div class="col-md-4">
                        <div class="card h-100">
                            <?php if($row['resim']): ?>
                            <img src="uploads/yazilar/<?php echo $row['resim']; ?>" class="card-img-top" alt="<?php echo $row['baslik']; ?>" style="height: 200px; object-fit: cover;">
                            <?php endif; ?>
                            <div class="card-body">
                                <h5 class="card-title">
                                    <a href="yazi-detay.php?slug=<?php echo $row['slug']; ?>" class="text-dark text-decoration-none">
                                        <?php echo $row['baslik']; ?>
                                    </a>
                                </h5>
                                <p class="card-text"><?php echo mb_substr(strip_tags($row['ozet']), 0, 100) . '...'; ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </section>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Hızlı Erişim</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li><a href="yazilar.php">Tüm Yazılar</a></li>
                        <li><a href="mevzuat.php">Mevzuat</a></li>
                        <li><a href="ictihat.php">İçtihat</a></li>
                        <li><a href="iletisim.php">İletişim</a></li>
                    </ul>
                </div>
            </div>

            <!-- Son Eklenen Yazılar -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Son Eklenen Yazılar</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <?php
                        $sql = "SELECT baslik, slug FROM yazilar ORDER BY created_at DESC LIMIT 5";
                        $result = mysqli_query($conn, $sql);
                        while($row = mysqli_fetch_assoc($result)):
                        ?>
                        <li class="mb-2">
                            <a href="yazi-detay.php?slug=<?php echo $row['slug']; ?>">
                                <?php echo $row['baslik']; ?>
                            </a>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.content {
    line-height: 1.8;
    font-size: 1.1em;
}

.content img {
    max-width: 100%;
    height: auto;
    margin: 20px 0;
}

.content h2,
.content h3,
.content h4 {
    margin-top: 30px;
    margin-bottom: 15px;
}

.content p {
    margin-bottom: 20px;
}

.content ul,
.content ol {
    margin-bottom: 20px;
    padding-left: 20px;
}

.content blockquote {
    margin: 20px 0;
    padding: 20px;
    background-color: #f8f9fa;
    border-left: 5px solid #007bff;
    font-style: italic;
}

.content pre {
    background-color: #f8f9fa;
    padding: 15px;
    border-radius: 4px;
    overflow-x: auto;
}

.content table {
    width: 100%;
    margin-bottom: 20px;
    border-collapse: collapse;
}

.content table th,
.content table td {
    padding: 10px;
    border: 1px solid #dee2e6;
}

.content table th {
    background-color: #f8f9fa;
    font-weight: bold;
}
</style>

<?php include 'footer.php'; ?> 