<?php
require_once 'config.php';

if(!isset($_GET['slug'])) {
    header("Location: index.php");
    exit;
}

$slug = $_GET['slug'];

// Sayfayı getir
$sql = "SELECT * FROM sayfalar WHERE slug = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "s", $slug);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$sayfa = mysqli_fetch_assoc($result);

if(!$sayfa) {
    header("Location: index.php");
    exit;
}

$page_title = $sayfa['baslik'] . " - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row">
        <div class="col-lg-8">
            <article>
                <header class="mb-4">
                    <h1><?php echo $sayfa['baslik']; ?></h1>
                </header>

                <div class="content">
                    <?php echo $sayfa['icerik']; ?>
                </div>
            </article>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Hızlı Erişim</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li><a href="yazilar.php">Yazılar</a></li>
                        <li><a href="mevzuat.php">Mevzuat</a></li>
                        <li><a href="ictihat.php">İçtihat</a></li>
                        <li><a href="iletisim.php">İletişim</a></li>
                    </ul>
                </div>
            </div>

            <!-- Son Eklenen Yazılar -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Son Eklenen Yazılar</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <?php
                        $sql = "SELECT baslik, slug FROM yazilar ORDER BY created_at DESC LIMIT 5";
                        $result = mysqli_query($conn, $sql);
                        while($row = mysqli_fetch_assoc($result)):
                        ?>
                        <li class="mb-2">
                            <a href="yazi-detay.php?slug=<?php echo $row['slug']; ?>">
                                <?php echo $row['baslik']; ?>
                            </a>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.content {
    line-height: 1.8;
    font-size: 1.1em;
}

.content img {
    max-width: 100%;
    height: auto;
    margin: 20px 0;
}

.content h2,
.content h3,
.content h4 {
    margin-top: 30px;
    margin-bottom: 15px;
}

.content p {
    margin-bottom: 20px;
}

.content ul,
.content ol {
    margin-bottom: 20px;
    padding-left: 20px;
}

.content blockquote {
    margin: 20px 0;
    padding: 20px;
    background-color: #f8f9fa;
    border-left: 5px solid #007bff;
    font-style: italic;
}

.content pre {
    background-color: #f8f9fa;
    padding: 15px;
    border-radius: 4px;
    overflow-x: auto;
}

.content table {
    width: 100%;
    margin-bottom: 20px;
    border-collapse: collapse;
}

.content table th,
.content table td {
    padding: 10px;
    border: 1px solid #dee2e6;
}

.content table th {
    background-color: #f8f9fa;
    font-weight: bold;
}
</style>

<?php include 'footer.php'; ?> 