<?php
require_once 'config.php';

$mesaj = '';
$hata = '';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $ad_soyad = $_POST['ad_soyad'];
    $email = $_POST['email'];
    $telefon = $_POST['telefon'];
    $konu = $_POST['konu'];
    $tarih = $_POST['tarih'];
    $saat = $_POST['saat'];
    $aciklama = $_POST['aciklama'];
    
    // Tarih kontrolü
    $randevu_tarihi = strtotime($tarih);
    $bugun = strtotime(date('Y-m-d'));
    
    if($randevu_tarihi < $bugun) {
        $hata = "Geçmiş bir tarih seçemezsiniz.";
    } else {
        // Seçilen saatin mesai saatleri içinde olup olmadığını kontrol et
        $saat_dakika = explode(':', $saat);
        $saat_int = (int)$saat_dakika[0];
        
        if($saat_int < 9 || $saat_int >= 18) {
            $hata = "Lütfen 09:00 - 18:00 arasında bir saat seçin.";
        } else {
            // Seçilen tarih ve saatte başka randevu var mı kontrol et
            $sql = "SELECT COUNT(*) as total FROM randevular WHERE tarih = ? AND saat = ? AND durum != 'reddedildi'";
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, "ss", $tarih, $saat);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            $row = mysqli_fetch_assoc($result);
            
            if($row['total'] > 0) {
                $hata = "Seçtiğiniz tarih ve saatte başka bir randevu bulunmaktadır. Lütfen farklı bir zaman seçin.";
            } else {
                $sql = "INSERT INTO randevular (ad_soyad, email, telefon, konu, tarih, saat, aciklama) VALUES (?, ?, ?, ?, ?, ?, ?)";
                $stmt = mysqli_prepare($conn, $sql);
                mysqli_stmt_bind_param($stmt, "sssssss", $ad_soyad, $email, $telefon, $konu, $tarih, $saat, $aciklama);
                
                if(mysqli_stmt_execute($stmt)) {
                    $mesaj = "Randevu talebiniz başarıyla alınmıştır. En kısa sürede size dönüş yapılacaktır.";
                } else {
                    $hata = "Bir hata oluştu, lütfen tekrar deneyin.";
                }
            }
        }
    }
}

$page_title = "Randevu Al - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h1 class="h3 mb-0">Randevu Al</h1>
                </div>
                <div class="card-body">
                    <?php if($mesaj): ?>
                    <div class="alert alert-success">
                        <?php echo $mesaj; ?>
                    </div>
                    <?php endif; ?>

                    <?php if($hata): ?>
                    <div class="alert alert-danger">
                        <?php echo $hata; ?>
                    </div>
                    <?php endif; ?>

                    <form action="" method="post">
                        <div class="form-group">
                            <label for="ad_soyad">Ad Soyad</label>
                            <input type="text" class="form-control" id="ad_soyad" name="ad_soyad" required>
                        </div>

                        <div class="form-group">
                            <label for="email">E-posta</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>

                        <div class="form-group">
                            <label for="telefon">Telefon</label>
                            <input type="tel" class="form-control" id="telefon" name="telefon" required>
                        </div>

                        <div class="form-group">
                            <label for="konu">Randevu Konusu</label>
                            <select class="form-control" id="konu" name="konu" required>
                                <option value="">Seçiniz</option>
                                <option value="Hukuki Danışmanlık">Hukuki Danışmanlık</option>
                                <option value="Dava Açma">Dava Açma</option>
                                <option value="Sözleşme İnceleme">Sözleşme İnceleme</option>
                                <option value="İcra Takibi">İcra Takibi</option>
                                <option value="Diğer">Diğer</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="tarih">Randevu Tarihi</label>
                            <input type="date" class="form-control" id="tarih" name="tarih" min="<?php echo date('Y-m-d'); ?>" required>
                        </div>

                        <div class="form-group">
                            <label for="saat">Randevu Saati</label>
                            <select class="form-control" id="saat" name="saat" required>
                                <option value="">Seçiniz</option>
                                <?php
                                for($saat = 9; $saat < 18; $saat++) {
                                    $saat_str = str_pad($saat, 2, '0', STR_PAD_LEFT);
                                    echo "<option value=\"{$saat_str}:00\">{$saat_str}:00</option>";
                                    echo "<option value=\"{$saat_str}:30\">{$saat_str}:30</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="aciklama">Açıklama</label>
                            <textarea class="form-control" id="aciklama" name="aciklama" rows="3"></textarea>
                            <small class="form-text text-muted">Randevu konusuyla ilgili kısa bir açıklama yazabilirsiniz.</small>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-calendar-check"></i> Randevu Talebi Gönder
                        </button>
                    </form>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h2 class="h4 mb-0">Önemli Bilgiler</h2>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-3">
                            <i class="fas fa-info-circle text-primary"></i>
                            Randevu talepleriniz büromuz tarafından kontrol edildikten sonra size e-posta veya telefon yoluyla dönüş yapılacaktır.
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-clock text-primary"></i>
                            Randevular hafta içi 09:00 - 18:00 saatleri arasında alınmaktadır.
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-calendar-alt text-primary"></i>
                            Randevu tarihinden en az 24 saat önce iptal etmeniz durumunda yeni bir randevu alabilirsiniz.
                        </li>
                        <li>
                            <i class="fas fa-phone text-primary"></i>
                            Acil durumlar için mesai saatleri içerisinde büromuzla iletişime geçebilirsiniz.
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.form-control:focus {
    border-color: #80bdff;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}

.card {
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #eee;
}

.btn-primary {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
}

.fas {
    margin-right: 0.5rem;
}
</style>

<?php include 'footer.php'; ?> 