<?php
require_once 'config.php';

// Sayfalama için değişkenler
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 10;
$offset = ($sayfa - 1) * $limit;

// Toplam mevzuat sayısını al
$total_sql = "SELECT COUNT(*) as total FROM mevzuat";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_assoc($total_result);
$total_mevzuat = $total_row['total'];
$total_pages = ceil($total_mevzuat / $limit);

// Mevzuatları getir
$sql = "SELECT * FROM mevzuat ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$page_title = "Mevzuat - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <h1 class="mb-4">Mevzuat</h1>
    
    <div class="row">
        <div class="col-lg-8">
            <?php if(mysqli_num_rows($result) > 0): ?>
                <div class="list-group">
                    <?php while($row = mysqli_fetch_assoc($result)): ?>
                    <a href="mevzuat-detay.php?slug=<?php echo $row['slug']; ?>" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1"><?php echo $row['baslik']; ?></h5>
                            <small class="text-muted"><?php echo date('d.m.Y', strtotime($row['created_at'])); ?></small>
                        </div>
                        <p class="mb-1"><?php echo mb_substr(strip_tags($row['icerik']), 0, 200) . '...'; ?></p>
                        <?php if($row['dosya']): ?>
                        <small class="text-muted">
                            <i class="fas fa-file-pdf"></i> Dosya mevcut
                        </small>
                        <?php endif; ?>
                    </a>
                    <?php endwhile; ?>
                </div>

                <?php if($total_pages > 1): ?>
                <nav class="mt-4">
                    <ul class="pagination justify-content-center">
                        <?php if($sayfa > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa-1; ?>">&laquo; Önceki</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                            <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if($sayfa < $total_pages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa+1; ?>">Sonraki &raquo;</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
            <?php else: ?>
                <div class="alert alert-info">
                    Henüz mevzuat bulunmamaktadır.
                </div>
            <?php endif; ?>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Hızlı Erişim</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li><a href="yazilar.php">Yazılar</a></li>
                        <li><a href="ictihat.php">İçtihat</a></li>
                        <li><a href="iletisim.php">İletişim</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?> 