<?php
require_once 'config.php';

$mesaj = '';
$hata = '';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $pozisyon = $_POST['pozisyon'];
    $ad_soyad = $_POST['ad_soyad'];
    $email = $_POST['email'];
    $telefon = $_POST['telefon'];
    $egitim = $_POST['egitim'];
    $deneyim = $_POST['deneyim'];
    
    // CV dosyası yükleme
    if(isset($_FILES['cv']) && $_FILES['cv']['error'] == 0) {
        $allowed = ['pdf', 'doc', 'docx'];
        $filename = $_FILES['cv']['name'];
        $filetype = pathinfo($filename, PATHINFO_EXTENSION);
        
        if(in_array(strtolower($filetype), $allowed)) {
            $newname = uniqid() . '.' . $filetype;
            $upload_path = 'uploads/cv/' . $newname;
            
            if(!is_dir('uploads/cv')) {
                mkdir('uploads/cv', 0777, true);
            }
            
            if(move_uploaded_file($_FILES['cv']['tmp_name'], $upload_path)) {
                $sql = "INSERT INTO kariyer (pozisyon, ad_soyad, email, telefon, egitim, deneyim, cv_dosya) VALUES (?, ?, ?, ?, ?, ?, ?)";
                $stmt = mysqli_prepare($conn, $sql);
                mysqli_stmt_bind_param($stmt, "sssssss", $pozisyon, $ad_soyad, $email, $telefon, $egitim, $deneyim, $upload_path);
                
                if(mysqli_stmt_execute($stmt)) {
                    $mesaj = "Başvurunuz başarıyla alınmıştır. En kısa sürede size dönüş yapılacaktır.";
                } else {
                    $hata = "Bir hata oluştu, lütfen tekrar deneyin.";
                }
            } else {
                $hata = "Dosya yüklenirken bir hata oluştu.";
            }
        } else {
            $hata = "Sadece PDF, DOC ve DOCX formatında dosyalar kabul edilmektedir.";
        }
    } else {
        $hata = "Lütfen CV dosyanızı yükleyin.";
    }
}

$page_title = "Kariyer - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row">
        <div class="col-lg-8">
            <h1 class="mb-4">Kariyer Fırsatları</h1>
            
            <div class="card mb-4">
                <div class="card-header">
                    <h2 class="h4 mb-0">Açık Pozisyonlar</h2>
                </div>
                <div class="card-body">
                    <div class="position mb-4">
                        <h3 class="h5">Avukat</h3>
                        <p>Büromuzda tam zamanlı olarak çalışacak, aşağıdaki niteliklere sahip avukat arayışımız bulunmaktadır:</p>
                        <ul>
                            <li>En az 2 yıl deneyimli</li>
                            <li>İyi derecede İngilizce bilen</li>
                            <li>MS Office programlarına hakim</li>
                            <li>Seyahat engeli olmayan</li>
                            <li>İletişim becerileri güçlü</li>
                        </ul>
                    </div>

                    <div class="position mb-4">
                        <h3 class="h5">Stajyer Avukat</h3>
                        <p>Büromuzda staj yapacak, aşağıdaki niteliklere sahip stajyer avukat arayışımız bulunmaktadır:</p>
                        <ul>
                            <li>Hukuk Fakültesi mezunu</li>
                            <li>İyi derecede İngilizce bilen</li>
                            <li>MS Office programlarına hakim</li>
                            <li>Öğrenmeye açık ve istekli</li>
                        </ul>
                    </div>

                    <div class="position">
                        <h3 class="h5">Hukuk Bürosu Asistanı</h3>
                        <p>Büromuzda tam zamanlı olarak çalışacak, aşağıdaki niteliklere sahip asistan arayışımız bulunmaktadır:</p>
                        <ul>
                            <li>Tercihen ön lisans veya lisans mezunu</li>
                            <li>MS Office programlarına hakim</li>
                            <li>Düzgün diksiyona sahip</li>
                            <li>İletişim becerileri güçlü</li>
                            <li>Organizasyon yeteneği yüksek</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h2 class="h4 mb-0">İş Başvuru Formu</h2>
                </div>
                <div class="card-body">
                    <?php if($mesaj): ?>
                    <div class="alert alert-success">
                        <?php echo $mesaj; ?>
                    </div>
                    <?php endif; ?>

                    <?php if($hata): ?>
                    <div class="alert alert-danger">
                        <?php echo $hata; ?>
                    </div>
                    <?php endif; ?>

                    <form action="" method="post" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="pozisyon">Başvurulan Pozisyon</label>
                            <select class="form-control" id="pozisyon" name="pozisyon" required>
                                <option value="">Seçiniz</option>
                                <option value="Avukat">Avukat</option>
                                <option value="Stajyer Avukat">Stajyer Avukat</option>
                                <option value="Hukuk Bürosu Asistanı">Hukuk Bürosu Asistanı</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="ad_soyad">Ad Soyad</label>
                            <input type="text" class="form-control" id="ad_soyad" name="ad_soyad" required>
                        </div>

                        <div class="form-group">
                            <label for="email">E-posta</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>

                        <div class="form-group">
                            <label for="telefon">Telefon</label>
                            <input type="tel" class="form-control" id="telefon" name="telefon" required>
                        </div>

                        <div class="form-group">
                            <label for="egitim">Eğitim Bilgileri</label>
                            <textarea class="form-control" id="egitim" name="egitim" rows="3" required></textarea>
                            <small class="form-text text-muted">Lütfen eğitim geçmişinizi detaylı bir şekilde yazınız.</small>
                        </div>

                        <div class="form-group">
                            <label for="deneyim">İş Deneyimi</label>
                            <textarea class="form-control" id="deneyim" name="deneyim" rows="3"></textarea>
                            <small class="form-text text-muted">Varsa iş deneyimlerinizi yazınız.</small>
                        </div>

                        <div class="form-group">
                            <label for="cv">CV</label>
                            <input type="file" class="form-control-file" id="cv" name="cv" required>
                            <small class="form-text text-muted">PDF, DOC veya DOCX formatında dosya yükleyiniz.</small>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane"></i> Başvuru Yap
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="h5 mb-0">Neden Biz?</h3>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success"></i>
                            Profesyonel gelişim imkanları
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success"></i>
                            Dinamik ve genç ekip
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success"></i>
                            Rekabetçi ücret politikası
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success"></i>
                            Modern çalışma ortamı
                        </li>
                        <li>
                            <i class="fas fa-check-circle text-success"></i>
                            Kariyer gelişim fırsatları
                        </li>
                    </ul>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h3 class="h5 mb-0">İletişim</h3>
                </div>
                <div class="card-body">
                    <p>Başvurunuzla ilgili sorularınız için:</p>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-envelope text-primary"></i>
                            kariyer@example.com
                        </li>
                        <li>
                            <i class="fas fa-phone text-primary"></i>
                            +90 (XXX) XXX XX XX
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.card {
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
    margin-bottom: 30px;
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #eee;
}

.position {
    padding-bottom: 20px;
    border-bottom: 1px solid #eee;
}

.position:last-child {
    padding-bottom: 0;
    border-bottom: none;
}

.position ul {
    margin-bottom: 0;
}

.form-control:focus {
    border-color: #80bdff;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}

.btn-primary {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
}

.fas {
    margin-right: 0.5rem;
}
</style>

<?php include 'footer.php'; ?> 