<?php
require_once 'config.php';

// Yazılar
$sql = "SELECT * FROM yazilar ORDER BY created_at DESC LIMIT 3";
$yazilar_result = mysqli_query($conn, $sql);

// Mevzuat
$sql = "SELECT * FROM mevzuat ORDER BY created_at DESC LIMIT 3";
$mevzuat_result = mysqli_query($conn, $sql);

// İçtihat
$sql = "SELECT * FROM ictihat ORDER BY created_at DESC LIMIT 3";
$ictihat_result = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Avukatlık Bürosu">
    <meta name="keywords" content="Avukat, Hukuk Bürosu">
    <title>Avukatlık Bürosu</title>
    <style>
        /* Genel Ayarlar */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            background-color: #f9fafb;
            color: #333;
            line-height: 1.6;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header */
        header {
            background: linear-gradient(120deg, rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 1));
            padding: 15px 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        /* ... Diğer CSS kodları ... */
    </style>
</head>
<body>
    <header>
        <div class="container">
            <div class="logo">
                <img src="img/logo.png" alt="Logo">
            </div>
            <nav>
                <ul>
                    <li><a href="index.php" class="active">Ana Sayfa</a></li>
                    <li><a href="hakkimizda.php">Hakkımızda</a></li>
                    <li><a href="calisma-alanlarimiz.php">Çalışma Alanlarımız</a></li>
                    <li><a href="yazilar.php">Yazılar</a></li>
                    <li><a href="mevzuat.php">Mevzuat</a></li>
                    <li><a href="ictihat.php">İçtihat</a></li>
                    <li><a href="galeri.php">Galeri</a></li>
                    <li><a href="iletisim.php">İletişim</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <section class="hero">
        <div class="container">
            <h1>Hukuki Çözüm Ortağınız</h1>
            <p>Profesyonel hukuk hizmetleri için yanınızdayız.</p>
            <a href="iletisim.php" class="cta-button">Bizimle İletişime Geçin</a>
        </div>
    </section>

    <section class="latest-posts">
        <div class="container">
            <h2>Son Yazılar</h2>
            <div class="posts-grid">
                <?php while($yazi = mysqli_fetch_assoc($yazilar_result)): ?>
                <div class="post-card">
                    <?php if($yazi['resim']): ?>
                    <img src="uploads/<?php echo $yazi['resim']; ?>" alt="<?php echo $yazi['baslik']; ?>">
                    <?php endif; ?>
                    <h3><?php echo $yazi['baslik']; ?></h3>
                    <p><?php echo substr($yazi['ozet'], 0, 150) . '...'; ?></p>
                    <a href="yazi-detay.php?slug=<?php echo $yazi['slug']; ?>" class="read-more">Devamını Oku</a>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>

    <section class="latest-content">
        <div class="container">
            <div class="row">
                <div class="col">
                    <h2>Son Mevzuat</h2>
                    <ul class="content-list">
                        <?php while($mevzuat = mysqli_fetch_assoc($mevzuat_result)): ?>
                        <li>
                            <a href="mevzuat-detay.php?slug=<?php echo $mevzuat['slug']; ?>">
                                <?php echo $mevzuat['baslik']; ?>
                            </a>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
                <div class="col">
                    <h2>Son İçtihat</h2>
                    <ul class="content-list">
                        <?php while($ictihat = mysqli_fetch_assoc($ictihat_result)): ?>
                        <li>
                            <a href="ictihat-detay.php?slug=<?php echo $ictihat['slug']; ?>">
                                <?php echo $ictihat['baslik']; ?>
                            </a>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3>İletişim</h3>
                    <p>Adres: [Adres Bilgisi]</p>
                    <p>Telefon: [Telefon Numarası]</p>
                    <p>E-posta: [E-posta Adresi]</p>
                </div>
                <div class="footer-section">
                    <h3>Hızlı Bağlantılar</h3>
                    <ul>
                        <li><a href="hakkimizda.php">Hakkımızda</a></li>
                        <li><a href="calisma-alanlarimiz.php">Çalışma Alanlarımız</a></li>
                        <li><a href="iletisim.php">İletişim</a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> Tüm hakları saklıdır.</p>
            </div>
        </div>
    </footer>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Mobil menü toggle
        $(document).ready(function() {
            $('.menu-toggle').click(function() {
                $('.navbar-nav').toggleClass('active');
            });

            // Dropdown menüler için
            $('.nav-item').click(function() {
                $(this).toggleClass('active');
            });
        });
    </script>
</body>
</html> 