<?php
require_once 'config.php';

$mesaj_gonderildi = false;
$hata = '';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $ad_soyad = $_POST['ad_soyad'];
    $email = $_POST['email'];
    $telefon = $_POST['telefon'];
    $mesaj = $_POST['mesaj'];
    
    // Form doğrulama
    if(empty($ad_soyad) || empty($email) || empty($mesaj)) {
        $hata = 'Lütfen zorunlu alanları doldurun.';
    } elseif(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $hata = 'Lütfen geçerli bir e-posta adresi girin.';
    } else {
        $sql = "INSERT INTO iletisim (ad_soyad, email, telefon, mesaj) VALUES (?, ?, ?, ?)";
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, "ssss", $ad_soyad, $email, $telefon, $mesaj);
        
        if(mysqli_stmt_execute($stmt)) {
            $mesaj_gonderildi = true;
        } else {
            $hata = 'Mesajınız gönderilirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.';
        }
    }
}

$page_title = "İletişim - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row">
        <div class="col-lg-8">
            <h1 class="mb-4">İletişim</h1>
            
            <?php if($mesaj_gonderildi): ?>
            <div class="alert alert-success">
                Mesajınız başarıyla gönderildi. En kısa sürede size dönüş yapacağız.
            </div>
            <?php endif; ?>
            
            <?php if($hata): ?>
            <div class="alert alert-danger">
                <?php echo $hata; ?>
            </div>
            <?php endif; ?>
            
            <form action="" method="post">
                <div class="form-group">
                    <label for="ad_soyad">Ad Soyad *</label>
                    <input type="text" class="form-control" id="ad_soyad" name="ad_soyad" required>
                </div>
                
                <div class="form-group">
                    <label for="email">E-posta *</label>
                    <input type="email" class="form-control" id="email" name="email" required>
                </div>
                
                <div class="form-group">
                    <label for="telefon">Telefon</label>
                    <input type="tel" class="form-control" id="telefon" name="telefon">
                </div>
                
                <div class="form-group">
                    <label for="mesaj">Mesaj *</label>
                    <textarea class="form-control" id="mesaj" name="mesaj" rows="5" required></textarea>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i> Gönder
                </button>
            </form>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">İletişim Bilgileri</h5>
                </div>
                <div class="card-body">
                    <p>
                        <i class="fas fa-map-marker-alt"></i> Adres:<br>
                        Örnek Mahallesi, Örnek Sokak No:123<br>
                        Örnek/İSTANBUL
                    </p>
                    
                    <p>
                        <i class="fas fa-phone"></i> Telefon:<br>
                        <a href="tel:+902121234567">0212 123 45 67</a>
                    </p>
                    
                    <p>
                        <i class="fas fa-envelope"></i> E-posta:<br>
                        <a href="mailto:info@example.com">info@example.com</a>
                    </p>
                    
                    <hr>
                    
                    <h6>Çalışma Saatleri</h6>
                    <p class="mb-0">
                        Pazartesi - Cuma: 09:00 - 18:00<br>
                        Cumartesi: 09:00 - 13:00<br>
                        Pazar: Kapalı
                    </p>
                </div>
            </div>
            
            <!-- Google Harita -->
            <div class="card mt-4">
                <div class="card-body p-0">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3009.1375984850843!2d28.97705931537386!3d41.03715297929822!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14cab7650656bd63%3A0x8ca058b28c20b6c3!2zVGFrc2ltIE1leWRhbsSxLCBHw7xtw7zFn3N1eXUsIDM0NDM1IEJleW_En2x1L8Swc3RhbmJ1bA!5e0!3m2!1str!2str!4v1629789876543!5m2!1str!2str" width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include 'footer.php'; ?> 