<?php
require_once 'config.php';

if(!isset($_GET['slug'])) {
    header("Location: ictihat.php");
    exit;
}

$slug = $_GET['slug'];

// İçtihatı getir
$sql = "SELECT * FROM ictihat WHERE slug = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "s", $slug);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$ictihat = mysqli_fetch_assoc($result);

if(!$ictihat) {
    header("Location: ictihat.php");
    exit;
}

$page_title = $ictihat['baslik'] . " - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row">
        <div class="col-lg-8">
            <article>
                <header class="mb-4">
                    <h1><?php echo $ictihat['baslik']; ?></h1>
                    <div class="text-muted">
                        <i class="fas fa-calendar"></i> <?php echo date('d.m.Y', strtotime($ictihat['created_at'])); ?>
                    </div>
                </header>

                <?php if($ictihat['dosya']): ?>
                <div class="mb-4">
                    <a href="uploads/ictihat/<?php echo $ictihat['dosya']; ?>" class="btn btn-primary" target="_blank">
                        <i class="fas fa-file-pdf"></i> Dosyayı İndir
                    </a>
                </div>
                <?php endif; ?>

                <div class="content">
                    <?php echo $ictihat['icerik']; ?>
                </div>
            </article>

            <hr class="my-5">

            <!-- Diğer İçtihatlar -->
            <section>
                <h3>Diğer İçtihatlar</h3>
                <div class="list-group">
                    <?php
                    $sql = "SELECT baslik, slug FROM ictihat WHERE id != ? ORDER BY created_at DESC LIMIT 5";
                    $stmt = mysqli_prepare($conn, $sql);
                    mysqli_stmt_bind_param($stmt, "i", $ictihat['id']);
                    mysqli_stmt_execute($stmt);
                    $result = mysqli_stmt_get_result($stmt);
                    while($row = mysqli_fetch_assoc($result)):
                    ?>
                    <a href="ictihat-detay.php?slug=<?php echo $row['slug']; ?>" class="list-group-item list-group-item-action">
                        <?php echo $row['baslik']; ?>
                    </a>
                    <?php endwhile; ?>
                </div>
            </section>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Hızlı Erişim</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li><a href="yazilar.php">Yazılar</a></li>
                        <li><a href="mevzuat.php">Mevzuat</a></li>
                        <li><a href="iletisim.php">İletişim</a></li>
                    </ul>
                </div>
            </div>

            <!-- Son Eklenen İçtihatlar -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Son Eklenen İçtihatlar</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <?php
                        $sql = "SELECT baslik, slug FROM ictihat ORDER BY created_at DESC LIMIT 5";
                        $result = mysqli_query($conn, $sql);
                        while($row = mysqli_fetch_assoc($result)):
                        ?>
                        <li class="mb-2">
                            <a href="ictihat-detay.php?slug=<?php echo $row['slug']; ?>">
                                <?php echo $row['baslik']; ?>
                            </a>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.content {
    line-height: 1.8;
    font-size: 1.1em;
}

.content img {
    max-width: 100%;
    height: auto;
    margin: 20px 0;
}

.content h2,
.content h3,
.content h4 {
    margin-top: 30px;
    margin-bottom: 15px;
}

.content p {
    margin-bottom: 20px;
}

.content ul,
.content ol {
    margin-bottom: 20px;
    padding-left: 20px;
}
</style>

<?php include 'footer.php'; ?> 