<?php
// Ayarları getir
$sql = "SELECT * FROM ayarlar WHERE id = 1";
$result = mysqli_query($conn, $sql);
$ayarlar = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title : $ayarlar['site_baslik']; ?></title>
    <meta name="description" content="<?php echo $ayarlar['site_aciklama']; ?>">
    
    <?php if($ayarlar['favicon']): ?>
    <link rel="icon" type="image/x-icon" href="uploads/<?php echo $ayarlar['favicon']; ?>">
    <?php endif; ?>
    
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        /* Header Styles */
        .top-bar {
            background: #343a40;
            color: #fff;
            padding: 8px 0;
            font-size: 14px;
        }
        .top-bar a {
            color: #fff;
            text-decoration: none;
        }
        .top-bar a:hover {
            color: #ccc;
        }
        .social-links a {
            margin-left: 15px;
        }
        .navbar {
            padding: 20px 0;
            background: #fff;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .navbar-brand img {
            max-height: 50px;
        }
        .nav-link {
            font-weight: 500;
            padding: 8px 15px !important;
            transition: color 0.3s;
        }
        .nav-link:hover {
            color: #007bff !important;
        }
    </style>
</head>
<body>
    <!-- Top Bar -->
    <div class="top-bar">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <?php if($ayarlar['telefon']): ?>
                    <a href="tel:<?php echo $ayarlar['telefon']; ?>">
                        <i class="fas fa-phone"></i> <?php echo $ayarlar['telefon']; ?>
                    </a>
                    <?php endif; ?>
                    
                    <?php if($ayarlar['email']): ?>
                    <a href="mailto:<?php echo $ayarlar['email']; ?>" class="ml-3">
                        <i class="fas fa-envelope"></i> <?php echo $ayarlar['email']; ?>
                    </a>
                    <?php endif; ?>
                </div>
                <div class="col-md-6 text-right social-links">
                    <?php if($ayarlar['facebook']): ?>
                    <a href="<?php echo $ayarlar['facebook']; ?>" target="_blank">
                        <i class="fab fa-facebook"></i>
                    </a>
                    <?php endif; ?>
                    
                    <?php if($ayarlar['twitter']): ?>
                    <a href="<?php echo $ayarlar['twitter']; ?>" target="_blank">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <?php endif; ?>
                    
                    <?php if($ayarlar['instagram']): ?>
                    <a href="<?php echo $ayarlar['instagram']; ?>" target="_blank">
                        <i class="fab fa-instagram"></i>
                    </a>
                    <?php endif; ?>
                    
                    <?php if($ayarlar['linkedin']): ?>
                    <a href="<?php echo $ayarlar['linkedin']; ?>" target="_blank">
                        <i class="fab fa-linkedin"></i>
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <?php if($ayarlar['logo']): ?>
                <img src="uploads/<?php echo $ayarlar['logo']; ?>" alt="<?php echo $ayarlar['site_baslik']; ?>">
                <?php else: ?>
                <?php echo $ayarlar['site_baslik']; ?>
                <?php endif; ?>
            </a>
            
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="yazilar.php">Yazılar</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="mevzuat.php">Mevzuat</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="ictihat.php">İçtihat</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="galeri.php">Galeri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="iletisim.php">İletişim</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
</body>
</html> 