<?php
require_once 'config.php';

$error_code = $_SERVER['REDIRECT_STATUS'] ?? 404;
$error_messages = [
    400 => 'Hatalı İstek',
    401 => 'Yetkisiz Erişim',
    403 => 'Erişim Yasak',
    404 => 'Sayfa Bulunamadı',
    500 => 'Sunucu Hatası'
];

$error_descriptions = [
    400 => 'Sunucuya gönderilen istek hatalı veya eksik.',
    401 => 'Bu sayfaya erişmek için yetkiniz bulunmuyor.',
    403 => 'Bu sayfaya erişiminiz engellendi.',
    404 => 'Aradığınız sayfa bulunamadı veya taşınmış olabilir.',
    500 => 'Sunucuda beklenmeyen bir hata oluştu. Lütfen daha sonra tekrar deneyin.'
];

$error_title = $error_messages[$error_code] ?? 'Hata';
$error_description = $error_descriptions[$error_code] ?? 'Beklenmeyen bir hata oluştu.';

$page_title = $error_title . " - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8 text-center">
            <div class="error-page py-5">
                <h1 class="display-1 text-primary mb-4"><?php echo $error_code; ?></h1>
                <h2 class="h3 mb-4"><?php echo $error_title; ?></h2>
                <p class="lead mb-5"><?php echo $error_description; ?></p>
                <div class="d-flex justify-content-center gap-3">
                    <a href="javascript:history.back()" class="btn btn-outline-primary me-3">
                        <i class="fas fa-arrow-left"></i> Geri Dön
                    </a>
                    <a href="/" class="btn btn-primary">
                        <i class="fas fa-home"></i> Ana Sayfa
                    </a>
                </div>
            </div>

            <div class="mt-5">
                <h3 class="h4 mb-4">Yardımcı Olabilecek Bağlantılar</h3>
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-body">
                                <i class="fas fa-phone-alt fa-2x text-primary mb-3"></i>
                                <h4 class="h5 mb-3">İletişime Geçin</h4>
                                <p class="mb-0">Sorularınız için bize ulaşabilirsiniz.</p>
                                <a href="/iletisim" class="stretched-link"></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-4">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-body">
                                <i class="fas fa-search fa-2x text-primary mb-3"></i>
                                <h4 class="h5 mb-3">Yazılarımız</h4>
                                <p class="mb-0">Hukuki makalelerimizi inceleyin.</p>
                                <a href="/yazilar" class="stretched-link"></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.error-page {
    padding: 60px 0;
}

.display-1 {
    font-size: 8rem;
    font-weight: 700;
    color: #007bff;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
}

.card {
    transition: transform 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
}

.btn {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
}

.fas {
    margin-right: 0.5rem;
}

.gap-3 {
    gap: 1rem;
}
</style>

<?php include 'footer.php'; ?> 