<?php
require_once 'config.php';

$page_title = "Hakkımızda - Avukatlık Bürosu";
include 'header.php';
?>

<main>
    <!-- Hero Section -->
    <section class="hero bg-light py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 mb-4">Hukuki Çözüm Ortağınız</h1>
                    <p class="lead mb-4">20 yılı aşkın tecrübemiz ve uzman kadromuzla müvekkillerimize en iyi hukuki danışmanlık hizmetini sunuyoruz.</p>
                    <a href="iletisim.php" class="btn btn-primary btn-lg">Bizimle İletişime Geçin</a>
                </div>
                <div class="col-lg-6">
                    <img src="assets/img/office.jpg" alt="Hukuk Bürosu" class="img-fluid rounded shadow">
                </div>
            </div>
        </div>
    </section>

    <!-- Hakkımızda Section -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mx-auto text-center">
                    <h2 class="mb-4">Biz Kimiz?</h2>
                    <p class="lead mb-5">2003 yılında kurulan hukuk büromuz, geniş bir yelpazede hukuki danışmanlık ve avukatlık hizmetleri sunmaktadır. Müvekkillerimizin hukuki sorunlarına çözüm odaklı yaklaşımımız ve profesyonel hizmet anlayışımızla, Türkiye'nin önde gelen hukuk bürolarından biri haline gelmiş bulunmaktayız.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Değerlerimiz Section -->
    <section class="bg-light py-5">
        <div class="container">
            <h2 class="text-center mb-5">Değerlerimiz</h2>
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="card h-100 border-0 shadow">
                        <div class="card-body text-center">
                            <i class="fas fa-balance-scale fa-3x text-primary mb-3"></i>
                            <h3 class="h4 mb-3">Adalet</h3>
                            <p>Her zaman adaletin tecellisi için çalışıyor, hukukun üstünlüğünü savunuyoruz.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card h-100 border-0 shadow">
                        <div class="card-body text-center">
                            <i class="fas fa-handshake fa-3x text-primary mb-3"></i>
                            <h3 class="h4 mb-3">Güven</h3>
                            <p>Müvekkillerimizle güvene dayalı, şeffaf ve uzun vadeli ilişkiler kuruyoruz.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card h-100 border-0 shadow">
                        <div class="card-body text-center">
                            <i class="fas fa-chart-line fa-3x text-primary mb-3"></i>
                            <h3 class="h4 mb-3">Başarı</h3>
                            <p>Her davada en iyi sonucu almak için titizlikle çalışıyor ve stratejik yaklaşıyoruz.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Ekibimiz Section -->
    <section class="py-5">
        <div class="container">
            <h2 class="text-center mb-5">Uzman Ekibimiz</h2>
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="card border-0 shadow">
                        <img src="assets/img/lawyer1.jpg" class="card-img-top" alt="Avukat">
                        <div class="card-body text-center">
                            <h3 class="h5 mb-2">Av. Mehmet Yılmaz</h3>
                            <p class="text-muted mb-3">Kurucu Ortak</p>
                            <p>Ticaret Hukuku ve Şirketler Hukuku alanlarında 20 yıllık deneyim.</p>
                            <div class="social-links">
                                <a href="#" class="text-dark me-2"><i class="fab fa-linkedin"></i></a>
                                <a href="#" class="text-dark me-2"><i class="fab fa-twitter"></i></a>
                                <a href="#" class="text-dark"><i class="fas fa-envelope"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card border-0 shadow">
                        <img src="assets/img/lawyer2.jpg" class="card-img-top" alt="Avukat">
                        <div class="card-body text-center">
                            <h3 class="h5 mb-2">Av. Ayşe Demir</h3>
                            <p class="text-muted mb-3">Ortak</p>
                            <p>İş Hukuku ve Sosyal Güvenlik Hukuku alanlarında uzman.</p>
                            <div class="social-links">
                                <a href="#" class="text-dark me-2"><i class="fab fa-linkedin"></i></a>
                                <a href="#" class="text-dark me-2"><i class="fab fa-twitter"></i></a>
                                <a href="#" class="text-dark"><i class="fas fa-envelope"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card border-0 shadow">
                        <img src="assets/img/lawyer3.jpg" class="card-img-top" alt="Avukat">
                        <div class="card-body text-center">
                            <h3 class="h5 mb-2">Av. Ali Kaya</h3>
                            <p class="text-muted mb-3">Kıdemli Avukat</p>
                            <p>Gayrimenkul Hukuku ve İcra-İflas Hukuku uzmanı.</p>
                            <div class="social-links">
                                <a href="#" class="text-dark me-2"><i class="fab fa-linkedin"></i></a>
                                <a href="#" class="text-dark me-2"><i class="fab fa-twitter"></i></a>
                                <a href="#" class="text-dark"><i class="fas fa-envelope"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Uzmanlık Alanları Section -->
    <section class="bg-light py-5">
        <div class="container">
            <h2 class="text-center mb-5">Uzmanlık Alanlarımız</h2>
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <h3 class="h5 mb-3">Ticaret Hukuku</h3>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>Şirketler Hukuku</li>
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>Sözleşmeler</li>
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>Birleşme ve Devralmalar</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <h3 class="h5 mb-3">İş Hukuku</h3>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>İş Davaları</li>
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>Toplu İş Hukuku</li>
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>İş Sözleşmeleri</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <h3 class="h5 mb-3">Gayrimenkul Hukuku</h3>
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>Tapu İşlemleri</li>
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>Kira Hukuku</li>
                                <li class="mb-2"><i class="fas fa-check text-primary me-2"></i>İnşaat Hukuku</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- İstatistikler Section -->
    <section class="py-5">
        <div class="container">
            <div class="row text-center">
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <i class="fas fa-users fa-3x text-primary mb-3"></i>
                            <h4 class="h2 mb-2">1000+</h4>
                            <p class="text-muted">Mutlu Müvekkil</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <i class="fas fa-gavel fa-3x text-primary mb-3"></i>
                            <h4 class="h2 mb-2">2500+</h4>
                            <p class="text-muted">Başarılı Dava</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <i class="fas fa-calendar-alt fa-3x text-primary mb-3"></i>
                            <h4 class="h2 mb-2">20+</h4>
                            <p class="text-muted">Yıllık Tecrübe</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <i class="fas fa-user-tie fa-3x text-primary mb-3"></i>
                            <h4 class="h2 mb-2">15+</h4>
                            <p class="text-muted">Uzman Avukat</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<style>
.hero {
    background: linear-gradient(rgba(255,255,255,.9), rgba(255,255,255,.9)), url('assets/img/hero-bg.jpg');
    background-size: cover;
    background-position: center;
}

.card {
    transition: transform 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
}

.social-links a {
    display: inline-block;
    width: 35px;
    height: 35px;
    line-height: 35px;
    border-radius: 50%;
    background-color: #f8f9fa;
    text-align: center;
    margin: 0 5px;
    transition: all 0.3s ease;
}

.social-links a:hover {
    background-color: #007bff;
    color: white !important;
}

.fas, .fab {
    margin-right: 0.5rem;
}

.text-primary {
    color: #007bff !important;
}

.btn-primary {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
}

.display-4 {
    font-weight: 600;
}

.lead {
    font-size: 1.1rem;
    line-height: 1.8;
}
</style>

<?php include 'footer.php'; ?> 