<?php
require_once 'config.php';

// Sayfalama için değişkenler
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 12;
$offset = ($sayfa - 1) * $limit;

// Toplam resim sayısını al
$total_sql = "SELECT COUNT(*) as total FROM galeri";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_assoc($total_result);
$total_galeri = $total_row['total'];
$total_pages = ceil($total_galeri / $limit);

// Resimleri getir
$sql = "SELECT * FROM galeri ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$page_title = "Galeri - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <h1 class="mb-4">Galeri</h1>
    
    <?php if(mysqli_num_rows($result) > 0): ?>
    <div class="row">
        <?php while($row = mysqli_fetch_assoc($result)): ?>
        <div class="col-md-4 col-lg-3 mb-4">
            <div class="card h-100">
                <a href="uploads/galeri/<?php echo $row['resim']; ?>" data-fancybox="gallery" data-caption="<?php echo htmlspecialchars($row['baslik']); ?>">
                    <img src="uploads/galeri/<?php echo $row['resim']; ?>" class="card-img-top" alt="<?php echo htmlspecialchars($row['baslik']); ?>" style="height: 200px; object-fit: cover;">
                </a>
                <div class="card-body">
                    <h5 class="card-title"><?php echo $row['baslik']; ?></h5>
                    <p class="card-text">
                        <small class="text-muted">
                            <i class="fas fa-calendar"></i> <?php echo date('d.m.Y', strtotime($row['created_at'])); ?>
                        </small>
                    </p>
                </div>
            </div>
        </div>
        <?php endwhile; ?>
    </div>

    <?php if($total_pages > 1): ?>
    <nav class="mt-4">
        <ul class="pagination justify-content-center">
            <?php if($sayfa > 1): ?>
            <li class="page-item">
                <a class="page-link" href="?sayfa=<?php echo $sayfa-1; ?>">&laquo; Önceki</a>
            </li>
            <?php endif; ?>
            
            <?php for($i = 1; $i <= $total_pages; $i++): ?>
            <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
            </li>
            <?php endfor; ?>
            
            <?php if($sayfa < $total_pages): ?>
            <li class="page-item">
                <a class="page-link" href="?sayfa=<?php echo $sayfa+1; ?>">Sonraki &raquo;</a>
            </li>
            <?php endif; ?>
        </ul>
    </nav>
    <?php endif; ?>
    <?php else: ?>
    <div class="alert alert-info">
        Henüz galeri resmi bulunmamaktadır.
    </div>
    <?php endif; ?>
</main>

<!-- Fancybox CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css">

<!-- Fancybox JS -->
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
<script>
    // Fancybox'ı başlat
    Fancybox.bind("[data-fancybox]", {
        // Ayarlar
    });
</script>

<?php include 'footer.php'; ?> 