<?php
require_once 'config.php';

$mesaj = '';
$hata = '';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $ad_soyad = $_POST['ad_soyad'];
    $email = $_POST['email'];
    $telefon = $_POST['telefon'];
    $dosya_no = $_POST['dosya_no'];
    $tutar = $_POST['tutar'];
    $aciklama = $_POST['aciklama'];
    
    $sql = "INSERT INTO tahsilatlar (ad_soyad, email, telefon, dosya_no, tutar, aciklama) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "ssssds", $ad_soyad, $email, $telefon, $dosya_no, $tutar, $aciklama);
    
    if(mysqli_stmt_execute($stmt)) {
        $mesaj = "Ödeme talebiniz başarıyla alınmıştır. En kısa sürede size dönüş yapılacaktır.";
    } else {
        $hata = "Bir hata oluştu, lütfen tekrar deneyin.";
    }
}

$page_title = "E-Tahsilat - Avukatlık Bürosu";
include 'header.php';
?>

<main class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h1 class="h3 mb-0">E-Tahsilat</h1>
                </div>
                <div class="card-body">
                    <?php if($mesaj): ?>
                    <div class="alert alert-success">
                        <?php echo $mesaj; ?>
                    </div>
                    <?php endif; ?>

                    <?php if($hata): ?>
                    <div class="alert alert-danger">
                        <?php echo $hata; ?>
                    </div>
                    <?php endif; ?>

                    <form action="" method="post">
                        <div class="form-group">
                            <label for="ad_soyad">Ad Soyad</label>
                            <input type="text" class="form-control" id="ad_soyad" name="ad_soyad" required>
                        </div>

                        <div class="form-group">
                            <label for="email">E-posta</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>

                        <div class="form-group">
                            <label for="telefon">Telefon</label>
                            <input type="tel" class="form-control" id="telefon" name="telefon" required>
                        </div>

                        <div class="form-group">
                            <label for="dosya_no">Dosya Numarası</label>
                            <input type="text" class="form-control" id="dosya_no" name="dosya_no" required>
                        </div>

                        <div class="form-group">
                            <label for="tutar">Ödeme Tutarı (TL)</label>
                            <input type="number" step="0.01" class="form-control" id="tutar" name="tutar" required>
                        </div>

                        <div class="form-group">
                            <label for="aciklama">Açıklama</label>
                            <textarea class="form-control" id="aciklama" name="aciklama" rows="3"></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane"></i> Ödeme Talebi Gönder
                        </button>
                    </form>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h2 class="h4 mb-0">Önemli Bilgiler</h2>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-3">
                            <i class="fas fa-info-circle text-primary"></i>
                            E-tahsilat sistemi üzerinden yapacağınız ödeme talepleri, büromuz tarafından kontrol edildikten sonra işleme alınacaktır.
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-clock text-primary"></i>
                            Ödeme talebiniz onaylandıktan sonra, size e-posta yoluyla ödeme bağlantısı gönderilecektir.
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-shield-alt text-primary"></i>
                            Tüm ödemeler güvenli ödeme altyapısı üzerinden gerçekleştirilmektedir.
                        </li>
                        <li>
                            <i class="fas fa-phone text-primary"></i>
                            Sorularınız için mesai saatleri içerisinde büromuzla iletişime geçebilirsiniz.
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
.form-control:focus {
    border-color: #80bdff;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}

.card {
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #eee;
}

.btn-primary {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
}

.fas {
    margin-right: 0.5rem;
}
</style>

<?php include 'footer.php'; ?> 