<?php
require_once 'config.php';

$page_title = "Çalışma Alanları - Avukatlık Bürosu";
include 'header.php';
?>

<main>
    <!-- Hero Section -->
    <section class="hero bg-light py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <h1 class="display-4 mb-4">Çalışma Alanlarımız</h1>
                    <p class="lead">Uzman kadromuzla birlikte geniş bir yelpazede hukuki danışmanlık ve avukatlık hizmetleri sunmaktayız.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Çalışma Alanları -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <!-- Ticaret Hukuku -->
                <div class="col-lg-6 mb-5">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-4">
                                <i class="fas fa-balance-scale fa-2x text-primary me-3"></i>
                                <h2 class="h3 mb-0">Ticaret Hukuku</h2>
                            </div>
                            <p class="mb-4">Şirketlerin kuruluşundan tasfiyesine kadar tüm süreçlerde hukuki danışmanlık hizmeti vermekteyiz.</p>
                            <ul class="list-unstyled">
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Şirket Kuruluşları ve Tasfiyeler</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Birleşme ve Devralmalar</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Ticari Sözleşmeler</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Rekabet Hukuku</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Yabancı Yatırımlar</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- İş Hukuku -->
                <div class="col-lg-6 mb-5">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-4">
                                <i class="fas fa-users fa-2x text-primary me-3"></i>
                                <h2 class="h3 mb-0">İş Hukuku</h2>
                            </div>
                            <p class="mb-4">İşçi ve işveren ilişkilerinde her iki tarafın haklarını gözeterek hukuki destek sağlıyoruz.</p>
                            <ul class="list-unstyled">
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>İş Sözleşmeleri</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>İşçi-İşveren Uyuşmazlıkları</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Toplu İş Hukuku</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>İş Kazaları</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Sosyal Güvenlik Hukuku</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Gayrimenkul Hukuku -->
                <div class="col-lg-6 mb-5">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-4">
                                <i class="fas fa-home fa-2x text-primary me-3"></i>
                                <h2 class="h3 mb-0">Gayrimenkul Hukuku</h2>
                            </div>
                            <p class="mb-4">Gayrimenkul alım-satım ve kiralama süreçlerinde hukuki danışmanlık hizmeti sunuyoruz.</p>
                            <ul class="list-unstyled">
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Tapu İşlemleri</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Kira Hukuku</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>İnşaat Hukuku</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Kat Mülkiyeti</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Kamulaştırma</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Aile Hukuku -->
                <div class="col-lg-6 mb-5">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-4">
                                <i class="fas fa-heart fa-2x text-primary me-3"></i>
                                <h2 class="h3 mb-0">Aile Hukuku</h2>
                            </div>
                            <p class="mb-4">Aile hukukuna ilişkin tüm süreçlerde uzman kadromuzla yanınızdayız.</p>
                            <ul class="list-unstyled">
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Boşanma Davaları</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Nafaka</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Velayet</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Mal Paylaşımı</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Miras Hukuku</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Ceza Hukuku -->
                <div class="col-lg-6 mb-5">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-4">
                                <i class="fas fa-gavel fa-2x text-primary me-3"></i>
                                <h2 class="h3 mb-0">Ceza Hukuku</h2>
                            </div>
                            <p class="mb-4">Ceza davalarında müvekkillerimizin haklarını en iyi şekilde savunuyoruz.</p>
                            <ul class="list-unstyled">
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Ağır Ceza Davaları</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Ekonomik Suçlar</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Siber Suçlar</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Trafik Suçları</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>İtiraz ve Temyiz</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- İdare Hukuku -->
                <div class="col-lg-6 mb-5">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-4">
                                <i class="fas fa-university fa-2x text-primary me-3"></i>
                                <h2 class="h3 mb-0">İdare Hukuku</h2>
                            </div>
                            <p class="mb-4">İdari işlem ve kararlara karşı hukuki yollarda sizlere destek oluyoruz.</p>
                            <ul class="list-unstyled">
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>İdari Davalar</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>İmar Hukuku</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Kamu İhale Hukuku</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Vergi Hukuku</li>
                                <li class="mb-3"><i class="fas fa-check text-primary me-2"></i>Disiplin Soruşturmaları</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="bg-light py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <h2 class="mb-4">Hukuki Desteğe mi İhtiyacınız Var?</h2>
                    <p class="lead mb-4">Uzman avukatlarımız size yardımcı olmak için hazır.</p>
                    <div class="d-flex justify-content-center gap-3">
                        <a href="/iletisim" class="btn btn-primary">
                            <i class="fas fa-phone-alt"></i> İletişime Geçin
                        </a>
                        <a href="/randevu" class="btn btn-outline-primary">
                            <i class="fas fa-calendar-alt"></i> Randevu Alın
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<style>
.hero {
    background: linear-gradient(rgba(255,255,255,.9), rgba(255,255,255,.9)), url('assets/img/hero-bg.jpg');
    background-size: cover;
    background-position: center;
}

.card {
    transition: transform 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
}

.btn {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
}

.fas {
    margin-right: 0.5rem;
}

.text-primary {
    color: #007bff !important;
}

.display-4 {
    font-weight: 600;
}

.lead {
    font-size: 1.1rem;
    line-height: 1.8;
}

.gap-3 {
    gap: 1rem;
}
</style>

<?php include 'footer.php'; ?> 