<?php
require_once 'config.php';

$slug = $db->real_escape_string($_GET['slug']);
$result = $db->query("SELECT * FROM calisma_alanlari WHERE slug = '$slug'");

if (!$result || !$result->num_rows) {
    header('Location: /');
    exit;
}

$row = $result->fetch_assoc();
$page_title = $row['baslik'] . " - Avukatlık Bürosu";
include 'header.php';

// Alt başlıkları diziye çevir
$alt_basliklar = explode("\n", $row['alt_basliklar']);
?>

<main>
    <!-- Hero Section -->
    <section class="hero bg-light py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 mx-auto text-center">
                    <h1 class="display-4 mb-4"><?php echo $row['baslik']; ?></h1>
                    <p class="lead mb-4"><?php echo $row['aciklama']; ?></p>
                    <div class="d-flex justify-content-center gap-3">
                        <a href="/iletisim" class="btn btn-primary">
                            <i class="fas fa-phone-alt"></i> İletişime Geçin
                        </a>
                        <a href="/randevu" class="btn btn-outline-primary">
                            <i class="fas fa-calendar-alt"></i> Randevu Alın
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Detay Section -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="content">
                        <?php echo $row['detay']; ?>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-body">
                            <h3 class="h4 mb-4">Hizmetlerimiz</h3>
                            <ul class="list-unstyled">
                                <?php foreach ($alt_basliklar as $baslik): ?>
                                <?php if (trim($baslik)): ?>
                                <li class="mb-3">
                                    <i class="fas fa-check text-primary me-2"></i>
                                    <?php echo trim($baslik); ?>
                                </li>
                                <?php endif; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <h3 class="h4 mb-4">İletişim</h3>
                            <p class="mb-4">Hukuki danışmanlık için bizimle iletişime geçebilirsiniz.</p>
                            <div class="d-grid gap-2">
                                <a href="/iletisim" class="btn btn-primary">
                                    <i class="fas fa-phone-alt"></i> İletişime Geçin
                                </a>
                                <a href="/randevu" class="btn btn-outline-primary">
                                    <i class="fas fa-calendar-alt"></i> Randevu Alın
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Diğer Çalışma Alanları -->
    <section class="bg-light py-5">
        <div class="container">
            <h2 class="text-center mb-5">Diğer Çalışma Alanlarımız</h2>
            <div class="row">
                <?php
                $other_areas = $db->query("SELECT baslik, slug, ikon, aciklama FROM calisma_alanlari WHERE slug != '$slug' LIMIT 3");
                while ($area = $other_areas->fetch_assoc()):
                ?>
                <div class="col-lg-4 mb-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-4">
                                <i class="<?php echo $area['ikon']; ?> fa-2x text-primary me-3"></i>
                                <h3 class="h4 mb-0"><?php echo $area['baslik']; ?></h3>
                            </div>
                            <p class="mb-4"><?php echo mb_substr($area['aciklama'], 0, 100) . '...'; ?></p>
                            <a href="/calisma-alani/<?php echo $area['slug']; ?>" class="btn btn-outline-primary">
                                Detaylı Bilgi
                            </a>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>
</main>

<style>
.hero {
    background: linear-gradient(rgba(255,255,255,.9), rgba(255,255,255,.9)), url('assets/img/hero-bg.jpg');
    background-size: cover;
    background-position: center;
}

.content {
    font-size: 1.1rem;
    line-height: 1.8;
}

.content h2 {
    margin-top: 2rem;
    margin-bottom: 1rem;
}

.content p {
    margin-bottom: 1.5rem;
}

.content ul {
    margin-bottom: 1.5rem;
}

.card {
    transition: transform 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
}

.btn {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
}

.fas {
    margin-right: 0.5rem;
}

.text-primary {
    color: #007bff !important;
}

.display-4 {
    font-weight: 600;
}

.lead {
    font-size: 1.1rem;
    line-height: 1.8;
}

.gap-3 {
    gap: 1rem;
}
</style>

<?php include 'footer.php'; ?> 