<?php
require_once '../config.php';
checkLogin();

// Silme işlemi
if(isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $id = $_GET['sil'];
    
    // Önce resmi sil
    $sql = "SELECT resim FROM yazilar WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    
    if($row['resim']) {
        @unlink('../uploads/yazilar/' . $row['resim']);
    }
    
    // Kaydı sil
    $sql = "DELETE FROM yazilar WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: yazilar.php?mesaj=silindi");
    exit;
}

// Sayfalama
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 10;
$offset = ($sayfa - 1) * $limit;

// Toplam yazı sayısı
$total_sql = "SELECT COUNT(*) as total FROM yazilar";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_assoc($total_result);
$total_yazilar = $total_row['total'];
$total_pages = ceil($total_yazilar / $limit);

// Yazıları getir
$sql = "SELECT * FROM yazilar ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yazılar - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Yazılar</h2>
                    <a href="yazi-ekle.php" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Yeni Yazı Ekle
                    </a>
                </div>

                <?php if(isset($_GET['mesaj'])): ?>
                <div class="alert alert-success">
                    <?php
                    $mesaj = $_GET['mesaj'];
                    switch($mesaj) {
                        case 'eklendi':
                            echo "Yazı başarıyla eklendi.";
                            break;
                        case 'guncellendi':
                            echo "Yazı başarıyla güncellendi.";
                            break;
                        case 'silindi':
                            echo "Yazı başarıyla silindi.";
                            break;
                    }
                    ?>
                </div>
                <?php endif; ?>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Resim</th>
                                <th>Başlık</th>
                                <th>Özet</th>
                                <th>Oluşturulma Tarihi</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($row = mysqli_fetch_assoc($result)): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td>
                                    <?php if($row['resim']): ?>
                                    <img src="../uploads/yazilar/<?php echo $row['resim']; ?>" alt="<?php echo $row['baslik']; ?>" style="width: 50px; height: 50px; object-fit: cover;">
                                    <?php else: ?>
                                    <div class="text-muted">Resim yok</div>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $row['baslik']; ?></td>
                                <td><?php echo mb_substr(strip_tags($row['ozet']), 0, 100) . '...'; ?></td>
                                <td><?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></td>
                                <td>
                                    <a href="yazi-duzenle.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-edit"></i> Düzenle
                                    </a>
                                    <a href="yazilar.php?sil=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu yazıyı silmek istediğinizden emin misiniz?')">
                                        <i class="fas fa-trash"></i> Sil
                                    </a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($total_pages > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if($sayfa > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa-1; ?>">&laquo; Önceki</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                            <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if($sayfa < $total_pages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa+1; ?>">Sonraki &raquo;</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html> 