<?php
require_once '../config.php';
checkLogin();

if(!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: yazilar.php");
    exit;
}

$id = $_GET['id'];

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $baslik = $_POST['baslik'];
    $ozet = $_POST['ozet'];
    $icerik = $_POST['icerik'];
    $slug = createSlug($baslik);
    
    // Resim yükleme
    $resim_sql = '';
    if(isset($_FILES['resim']) && $_FILES['resim']['error'] == 0) {
        $allowed = array('jpg', 'jpeg', 'png', 'gif');
        $filename = $_FILES['resim']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if(in_array($ext, $allowed)) {
            $newname = uniqid() . '.' . $ext;
            
            // Yazılar klasörü yoksa oluştur
            if(!file_exists('../uploads/yazilar')) {
                mkdir('../uploads/yazilar', 0777, true);
            }
            
            $target = '../uploads/yazilar/' . $newname;
            
            if(move_uploaded_file($_FILES['resim']['tmp_name'], $target)) {
                // Eski resmi sil
                $sql = "SELECT resim FROM yazilar WHERE id = ?";
                $stmt = mysqli_prepare($conn, $sql);
                mysqli_stmt_bind_param($stmt, "i", $id);
                mysqli_stmt_execute($stmt);
                $result = mysqli_stmt_get_result($stmt);
                $row = mysqli_fetch_assoc($result);
                
                if($row['resim']) {
                    @unlink('../uploads/yazilar/' . $row['resim']);
                }
                
                $resim_sql = ", resim = '$newname'";
            }
        }
    }
    
    $sql = "UPDATE yazilar SET baslik = ?, ozet = ?, icerik = ?, slug = ? $resim_sql WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "ssssi", $baslik, $ozet, $icerik, $slug, $id);
    
    if(mysqli_stmt_execute($stmt)) {
        header("Location: yazilar.php?mesaj=guncellendi");
        exit;
    }
}

// Yazıyı getir
$sql = "SELECT * FROM yazilar WHERE id = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "i", $id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$yazi = mysqli_fetch_assoc($result);

if(!$yazi) {
    header("Location: yazilar.php");
    exit;
}

// Slug oluşturma fonksiyonu
function createSlug($str) {
    $str = mb_strtolower($str, 'UTF-8');
    $str = str_replace(
        ['ı', 'ğ', 'ü', 'ş', 'ö', 'ç'],
        ['i', 'g', 'u', 's', 'o', 'c'],
        $str
    );
    $str = preg_replace('/[^a-z0-9]/', '-', $str);
    $str = preg_replace('/-+/', '-', $str);
    return trim($str, '-');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yazı Düzenle - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
        .image-preview {
            max-width: 300px;
            margin-top: 10px;
        }
        .image-preview img {
            width: 100%;
            height: auto;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Yazı Düzenle</h2>
                    <a href="yazilar.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Geri Dön
                    </a>
                </div>

                <form action="" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="baslik">Başlık</label>
                        <input type="text" class="form-control" id="baslik" name="baslik" value="<?php echo htmlspecialchars($yazi['baslik']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="ozet">Özet</label>
                        <textarea class="form-control" id="ozet" name="ozet" rows="3" required><?php echo htmlspecialchars($yazi['ozet']); ?></textarea>
                    </div>

                    <div class="form-group">
                        <label for="icerik">İçerik</label>
                        <textarea class="form-control" id="icerik" name="icerik" required><?php echo htmlspecialchars($yazi['icerik']); ?></textarea>
                    </div>

                    <div class="form-group">
                        <label for="resim">Resim</label>
                        <input type="file" class="form-control-file" id="resim" name="resim" accept="image/*">
                        <small class="form-text text-muted">İzin verilen formatlar: JPG, JPEG, PNG, GIF</small>
                        <?php if($yazi['resim']): ?>
                        <div class="image-preview mt-2">
                            <img src="../uploads/yazilar/<?php echo $yazi['resim']; ?>" class="img-thumbnail">
                        </div>
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Kaydet
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script>
        $(document).ready(function() {
            // Summernote editor'ı başlat
            $('#icerik').summernote({
                height: 300,
                lang: 'tr-TR',
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture']],
                    ['view', ['fullscreen', 'codeview']]
                ],
                callbacks: {
                    onImageUpload: function(files) {
                        for(let i = 0; i < files.length; i++) {
                            uploadImage(files[i], this);
                        }
                    }
                }
            });

            // Resim önizleme
            document.getElementById('resim').addEventListener('change', function(e) {
                const file = e.target.files[0];
                if(file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const preview = document.querySelector('.image-preview');
                        preview.innerHTML = `<img src="${e.target.result}" class="img-thumbnail">`;
                    }
                    reader.readAsDataURL(file);
                }
            });
        });

        // Summernote içine resim yükleme fonksiyonu
        function uploadImage(file, editor) {
            const formData = new FormData();
            formData.append('file', file);
            
            $.ajax({
                url: 'upload.php',
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $(editor).summernote('insertImage', response.url);
                },
                error: function(xhr, status, error) {
                    console.error('Resim yüklenirken hata oluştu:', error);
                }
            });
        }
    </script>
</body>
</html> 