<?php
require_once '../config.php';
checkLogin();

// Sadece AJAX isteklerine izin ver
if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') {
    die('Bu sayfaya doğrudan erişim yasaktır.');
}

// Dosya kontrolü
if(!isset($_FILES['file']) || $_FILES['file']['error'] != 0) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Dosya yüklenirken bir hata oluştu.']);
    exit;
}

// İzin verilen dosya türleri
$allowed = array('jpg', 'jpeg', 'png', 'gif');
$filename = $_FILES['file']['name'];
$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

if(!in_array($ext, $allowed)) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Sadece JPG, JPEG, PNG ve GIF dosyaları yüklenebilir.']);
    exit;
}

// Dosya boyutu kontrolü (5MB)
if($_FILES['file']['size'] > 5 * 1024 * 1024) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Dosya boyutu 5MB\'dan büyük olamaz.']);
    exit;
}

// Uploads klasörü yoksa oluştur
$upload_dir = '../uploads/editor';
if(!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// Benzersiz dosya adı oluştur
$newname = uniqid() . '.' . $ext;
$target = $upload_dir . '/' . $newname;

// Dosyayı yükle
if(move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
    header('Content-Type: application/json');
    echo json_encode(['url' => '../uploads/editor/' . $newname]);
    exit;
} else {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Dosya yüklenirken bir hata oluştu.']);
    exit;
} 