<?php
require_once '../config.php';
checkLogin();

// Durum güncelleme
if(isset($_GET['id']) && isset($_GET['durum'])) {
    $id = $_GET['id'];
    $durum = $_GET['durum'];
    
    $sql = "UPDATE tahsilatlar SET durum = ? WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "si", $durum, $id);
    mysqli_stmt_execute($stmt);
    header("Location: tahsilatlar.php?mesaj=guncellendi");
    exit;
}

// Silme işlemi
if(isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $id = $_GET['sil'];
    
    $sql = "DELETE FROM tahsilatlar WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: tahsilatlar.php?mesaj=silindi");
    exit;
}

// Sayfalama
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 10;
$offset = ($sayfa - 1) * $limit;

// Toplam kayıt sayısı
$total_sql = "SELECT COUNT(*) as total FROM tahsilatlar";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_assoc($total_result);
$total_records = $total_row['total'];
$total_pages = ceil($total_records / $limit);

// Tahsilatları getir
$sql = "SELECT * FROM tahsilatlar ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-Tahsilat Yönetimi - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
        .beklemede { background-color: #fff3cd; }
        .onaylandi { background-color: #d4edda; }
        .reddedildi { background-color: #f8d7da; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>E-Tahsilat Yönetimi</h2>
                </div>

                <?php if(isset($_GET['mesaj'])): ?>
                <div class="alert alert-success">
                    <?php
                    $mesaj = $_GET['mesaj'];
                    switch($mesaj) {
                        case 'guncellendi':
                            echo "Tahsilat durumu başarıyla güncellendi.";
                            break;
                        case 'silindi':
                            echo "Tahsilat kaydı başarıyla silindi.";
                            break;
                    }
                    ?>
                </div>
                <?php endif; ?>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Ad Soyad</th>
                                <th>E-posta</th>
                                <th>Telefon</th>
                                <th>Dosya No</th>
                                <th>Tutar</th>
                                <th>Durum</th>
                                <th>Tarih</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($row = mysqli_fetch_assoc($result)): ?>
                            <tr class="<?php echo $row['durum']; ?>">
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['ad_soyad']); ?></td>
                                <td><?php echo htmlspecialchars($row['email']); ?></td>
                                <td><?php echo htmlspecialchars($row['telefon']); ?></td>
                                <td><?php echo htmlspecialchars($row['dosya_no']); ?></td>
                                <td><?php echo number_format($row['tutar'], 2, ',', '.') . ' TL'; ?></td>
                                <td>
                                    <span class="badge badge-<?php 
                                        echo $row['durum'] == 'beklemede' ? 'warning' : 
                                            ($row['durum'] == 'onaylandi' ? 'success' : 'danger'); 
                                    ?>">
                                        <?php echo ucfirst($row['durum']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#detayModal<?php echo $row['id']; ?>">
                                        <i class="fas fa-eye"></i> Detay
                                    </button>
                                    <?php if($row['durum'] == 'beklemede'): ?>
                                    <a href="tahsilatlar.php?id=<?php echo $row['id']; ?>&durum=onaylandi" class="btn btn-sm btn-success">
                                        <i class="fas fa-check"></i> Onayla
                                    </a>
                                    <a href="tahsilatlar.php?id=<?php echo $row['id']; ?>&durum=reddedildi" class="btn btn-sm btn-danger">
                                        <i class="fas fa-times"></i> Reddet
                                    </a>
                                    <?php endif; ?>
                                    <a href="tahsilatlar.php?sil=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu tahsilat kaydını silmek istediğinizden emin misiniz?')">
                                        <i class="fas fa-trash"></i> Sil
                                    </a>
                                </td>
                            </tr>

                            <!-- Detay Modal -->
                            <div class="modal fade" id="detayModal<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detayModalLabel<?php echo $row['id']; ?>" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="detayModalLabel<?php echo $row['id']; ?>">Tahsilat Detayı</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <p><strong>Ad Soyad:</strong> <?php echo htmlspecialchars($row['ad_soyad']); ?></p>
                                            <p><strong>E-posta:</strong> <?php echo htmlspecialchars($row['email']); ?></p>
                                            <p><strong>Telefon:</strong> <?php echo htmlspecialchars($row['telefon']); ?></p>
                                            <p><strong>Dosya No:</strong> <?php echo htmlspecialchars($row['dosya_no']); ?></p>
                                            <p><strong>Tutar:</strong> <?php echo number_format($row['tutar'], 2, ',', '.') . ' TL'; ?></p>
                                            <p><strong>Durum:</strong> <?php echo ucfirst($row['durum']); ?></p>
                                            <p><strong>Tarih:</strong> <?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></p>
                                            <?php if($row['aciklama']): ?>
                                            <p><strong>Açıklama:</strong></p>
                                            <div class="border p-3 bg-light">
                                                <?php echo nl2br(htmlspecialchars($row['aciklama'])); ?>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
                                            <?php if($row['durum'] == 'beklemede'): ?>
                                            <a href="tahsilatlar.php?id=<?php echo $row['id']; ?>&durum=onaylandi" class="btn btn-success">
                                                <i class="fas fa-check"></i> Onayla
                                            </a>
                                            <a href="tahsilatlar.php?id=<?php echo $row['id']; ?>&durum=reddedildi" class="btn btn-danger">
                                                <i class="fas fa-times"></i> Reddet
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($total_pages > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if($sayfa > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa-1; ?>">&laquo; Önceki</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                            <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if($sayfa < $total_pages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa+1; ?>">Sonraki &raquo;</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html> 