<?php
require_once '../config.php';
checkLogin();

$mesaj = '';
$hata = '';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $kullanici_adi = $_POST['kullanici_adi'];
    $mevcut_sifre = $_POST['mevcut_sifre'];
    $yeni_sifre = $_POST['yeni_sifre'];
    $yeni_sifre_tekrar = $_POST['yeni_sifre_tekrar'];
    
    // Mevcut şifreyi kontrol et
    $sql = "SELECT sifre FROM admin WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $_SESSION['admin_id']);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $admin = mysqli_fetch_assoc($result);
    
    if(password_verify($mevcut_sifre, $admin['sifre'])) {
        if($yeni_sifre && $yeni_sifre_tekrar) {
            if($yeni_sifre === $yeni_sifre_tekrar) {
                $yeni_sifre_hash = password_hash($yeni_sifre, PASSWORD_DEFAULT);
                $sql = "UPDATE admin SET kullanici_adi = ?, sifre = ? WHERE id = ?";
                $stmt = mysqli_prepare($conn, $sql);
                mysqli_stmt_bind_param($stmt, "ssi", $kullanici_adi, $yeni_sifre_hash, $_SESSION['admin_id']);
            } else {
                $hata = "Yeni şifreler eşleşmiyor.";
            }
        } else {
            $sql = "UPDATE admin SET kullanici_adi = ? WHERE id = ?";
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, "si", $kullanici_adi, $_SESSION['admin_id']);
        }
        
        if(!$hata && mysqli_stmt_execute($stmt)) {
            $mesaj = "Profil bilgileri başarıyla güncellendi.";
            $_SESSION['admin_username'] = $kullanici_adi;
        } else if(!$hata) {
            $hata = "Bir hata oluştu, lütfen tekrar deneyin.";
        }
    } else {
        $hata = "Mevcut şifre yanlış.";
    }
}

// Admin bilgilerini getir
$sql = "SELECT kullanici_adi FROM admin WHERE id = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "i", $_SESSION['admin_id']);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$admin = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Profil</h2>
                </div>

                <?php if($mesaj): ?>
                <div class="alert alert-success">
                    <?php echo $mesaj; ?>
                </div>
                <?php endif; ?>

                <?php if($hata): ?>
                <div class="alert alert-danger">
                    <?php echo $hata; ?>
                </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <form action="" method="post">
                            <div class="form-group">
                                <label for="kullanici_adi">Kullanıcı Adı</label>
                                <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" value="<?php echo htmlspecialchars($admin['kullanici_adi']); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="mevcut_sifre">Mevcut Şifre</label>
                                <input type="password" class="form-control" id="mevcut_sifre" name="mevcut_sifre" required>
                            </div>

                            <div class="form-group">
                                <label for="yeni_sifre">Yeni Şifre (Değiştirmek istemiyorsanız boş bırakın)</label>
                                <input type="password" class="form-control" id="yeni_sifre" name="yeni_sifre">
                            </div>

                            <div class="form-group">
                                <label for="yeni_sifre_tekrar">Yeni Şifre Tekrar</label>
                                <input type="password" class="form-control" id="yeni_sifre_tekrar" name="yeni_sifre_tekrar">
                            </div>

                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Kaydet
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html> 