<?php
require_once '../config.php';
checkLogin();

// Durum güncelleme
if(isset($_GET['id']) && isset($_GET['durum'])) {
    $id = $_GET['id'];
    $durum = $_GET['durum'];
    
    $sql = "UPDATE kariyer SET durum = ? WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "si", $durum, $id);
    mysqli_stmt_execute($stmt);
    header("Location: kariyer.php?mesaj=guncellendi");
    exit;
}

// Silme işlemi
if(isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $id = $_GET['sil'];
    
    // Önce CV dosyasını sil
    $sql = "SELECT cv_dosya FROM kariyer WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    
    if($row && file_exists('../' . $row['cv_dosya'])) {
        unlink('../' . $row['cv_dosya']);
    }
    
    // Sonra kaydı sil
    $sql = "DELETE FROM kariyer WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: kariyer.php?mesaj=silindi");
    exit;
}

// Sayfalama
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 10;
$offset = ($sayfa - 1) * $limit;

// Toplam kayıt sayısı
$total_sql = "SELECT COUNT(*) as total FROM kariyer";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_assoc($total_result);
$total_records = $total_row['total'];
$total_pages = ceil($total_records / $limit);

// Başvuruları getir
$sql = "SELECT * FROM kariyer ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kariyer Başvuruları - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
        .beklemede { background-color: #fff3cd; }
        .incelendi { background-color: #cce5ff; }
        .kabul_edildi { background-color: #d4edda; }
        .reddedildi { background-color: #f8d7da; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Kariyer Başvuruları</h2>
                </div>

                <?php if(isset($_GET['mesaj'])): ?>
                <div class="alert alert-success">
                    <?php
                    $mesaj = $_GET['mesaj'];
                    switch($mesaj) {
                        case 'guncellendi':
                            echo "Başvuru durumu başarıyla güncellendi.";
                            break;
                        case 'silindi':
                            echo "Başvuru başarıyla silindi.";
                            break;
                    }
                    ?>
                </div>
                <?php endif; ?>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Pozisyon</th>
                                <th>Ad Soyad</th>
                                <th>E-posta</th>
                                <th>Telefon</th>
                                <th>Durum</th>
                                <th>Tarih</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($row = mysqli_fetch_assoc($result)): ?>
                            <tr class="<?php echo $row['durum']; ?>">
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['pozisyon']); ?></td>
                                <td><?php echo htmlspecialchars($row['ad_soyad']); ?></td>
                                <td><?php echo htmlspecialchars($row['email']); ?></td>
                                <td><?php echo htmlspecialchars($row['telefon']); ?></td>
                                <td>
                                    <span class="badge badge-<?php 
                                        echo $row['durum'] == 'beklemede' ? 'warning' : 
                                            ($row['durum'] == 'incelendi' ? 'info' : 
                                            ($row['durum'] == 'kabul_edildi' ? 'success' : 'danger')); 
                                    ?>">
                                        <?php echo ucfirst(str_replace('_', ' ', $row['durum'])); ?>
                                    </span>
                                </td>
                                <td><?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#detayModal<?php echo $row['id']; ?>">
                                        <i class="fas fa-eye"></i> Detay
                                    </button>
                                    <a href="../<?php echo $row['cv_dosya']; ?>" class="btn btn-sm btn-primary" target="_blank">
                                        <i class="fas fa-file-alt"></i> CV
                                    </a>
                                    <?php if($row['durum'] == 'beklemede'): ?>
                                    <a href="kariyer.php?id=<?php echo $row['id']; ?>&durum=incelendi" class="btn btn-sm btn-info">
                                        <i class="fas fa-search"></i> İncelendi
                                    </a>
                                    <a href="kariyer.php?id=<?php echo $row['id']; ?>&durum=kabul_edildi" class="btn btn-sm btn-success">
                                        <i class="fas fa-check"></i> Kabul Et
                                    </a>
                                    <a href="kariyer.php?id=<?php echo $row['id']; ?>&durum=reddedildi" class="btn btn-sm btn-danger">
                                        <i class="fas fa-times"></i> Reddet
                                    </a>
                                    <?php endif; ?>
                                    <a href="kariyer.php?sil=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu başvuruyu silmek istediğinizden emin misiniz?')">
                                        <i class="fas fa-trash"></i> Sil
                                    </a>
                                </td>
                            </tr>

                            <!-- Detay Modal -->
                            <div class="modal fade" id="detayModal<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detayModalLabel<?php echo $row['id']; ?>" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="detayModalLabel<?php echo $row['id']; ?>">Başvuru Detayı</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <p><strong>Ad Soyad:</strong> <?php echo htmlspecialchars($row['ad_soyad']); ?></p>
                                                    <p><strong>E-posta:</strong> <?php echo htmlspecialchars($row['email']); ?></p>
                                                    <p><strong>Telefon:</strong> <?php echo htmlspecialchars($row['telefon']); ?></p>
                                                    <p><strong>Pozisyon:</strong> <?php echo htmlspecialchars($row['pozisyon']); ?></p>
                                                    <p><strong>Durum:</strong> <?php echo ucfirst(str_replace('_', ' ', $row['durum'])); ?></p>
                                                    <p><strong>Tarih:</strong> <?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p><strong>Eğitim Bilgileri:</strong></p>
                                                    <div class="border p-3 bg-light mb-3">
                                                        <?php echo nl2br(htmlspecialchars($row['egitim'])); ?>
                                                    </div>
                                                    <?php if($row['deneyim']): ?>
                                                    <p><strong>İş Deneyimi:</strong></p>
                                                    <div class="border p-3 bg-light">
                                                        <?php echo nl2br(htmlspecialchars($row['deneyim'])); ?>
                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <a href="../<?php echo $row['cv_dosya']; ?>" class="btn btn-primary" target="_blank">
                                                <i class="fas fa-file-alt"></i> CV'yi Görüntüle
                                            </a>
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
                                            <?php if($row['durum'] == 'beklemede'): ?>
                                            <a href="kariyer.php?id=<?php echo $row['id']; ?>&durum=incelendi" class="btn btn-info">
                                                <i class="fas fa-search"></i> İncelendi
                                            </a>
                                            <a href="kariyer.php?id=<?php echo $row['id']; ?>&durum=kabul_edildi" class="btn btn-success">
                                                <i class="fas fa-check"></i> Kabul Et
                                            </a>
                                            <a href="kariyer.php?id=<?php echo $row['id']; ?>&durum=reddedildi" class="btn btn-danger">
                                                <i class="fas fa-times"></i> Reddet
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($total_pages > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if($sayfa > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa-1; ?>">&laquo; Önceki</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                            <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if($sayfa < $total_pages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa+1; ?>">Sonraki &raquo;</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html> 