<?php
require_once '../config.php';
checkLogin();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px 15px;
        }
        .sidebar a:hover {
            background: #454d55;
        }
        .content {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar">
                <h4 class="p-3">Admin Paneli</h4>
                <nav>
                    <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                    <a href="sayfalar.php"><i class="fas fa-file"></i> Sayfalar</a>
                    <a href="yazilar.php"><i class="fas fa-newspaper"></i> Yazılar</a>
                    <a href="mevzuat.php"><i class="fas fa-book"></i> Mevzuat</a>
                    <a href="ictihat.php"><i class="fas fa-gavel"></i> İçtihat</a>
                    <a href="galeri.php"><i class="fas fa-images"></i> Galeri</a>
                    <a href="iletisim.php"><i class="fas fa-envelope"></i> İletişim Mesajları</a>
                    <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                    <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
                </nav>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <h2>Hoş Geldiniz</h2>
                <p>Sol menüden yapmak istediğiniz işlemi seçebilirsiniz.</p>
                
                <!-- Quick Stats -->
                <div class="row mt-4">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <h5 class="card-title">Toplam Yazı</h5>
                                <?php
                                $sql = "SELECT COUNT(*) as total FROM yazilar";
                                $result = mysqli_query($conn, $sql);
                                $row = mysqli_fetch_assoc($result);
                                echo "<p class='card-text'>" . $row['total'] . "</p>";
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <h5 class="card-title">Toplam Mevzuat</h5>
                                <?php
                                $sql = "SELECT COUNT(*) as total FROM mevzuat";
                                $result = mysqli_query($conn, $sql);
                                $row = mysqli_fetch_assoc($result);
                                echo "<p class='card-text'>" . $row['total'] . "</p>";
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <h5 class="card-title">Toplam İçtihat</h5>
                                <?php
                                $sql = "SELECT COUNT(*) as total FROM ictihat";
                                $result = mysqli_query($conn, $sql);
                                $row = mysqli_fetch_assoc($result);
                                echo "<p class='card-text'>" . $row['total'] . "</p>";
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body">
                                <h5 class="card-title">Okunmamış Mesajlar</h5>
                                <?php
                                $sql = "SELECT COUNT(*) as total FROM iletisim WHERE okundu = 0";
                                $result = mysqli_query($conn, $sql);
                                $row = mysqli_fetch_assoc($result);
                                echo "<p class='card-text'>" . $row['total'] . "</p>";
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html> 