<?php
require_once '../config.php';
checkLogin();

// Mesajı okundu olarak işaretle
if(isset($_GET['okundu']) && is_numeric($_GET['okundu'])) {
    $id = $_GET['okundu'];
    $sql = "UPDATE iletisim SET okundu = 1 WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: iletisim.php?mesaj=okundu");
    exit;
}

// Mesajı sil
if(isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $id = $_GET['sil'];
    $sql = "DELETE FROM iletisim WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: iletisim.php?mesaj=silindi");
    exit;
}

// Sayfalama
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 10;
$offset = ($sayfa - 1) * $limit;

// Toplam mesaj sayısı
$total_sql = "SELECT COUNT(*) as total FROM iletisim";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_assoc($total_result);
$total_iletisim = $total_row['total'];
$total_pages = ceil($total_iletisim / $limit);

// Mesajları getir
$sql = "SELECT * FROM iletisim ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İletişim Mesajları - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
        .unread {
            background-color: #f8f9fa;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <h2 class="mb-4">İletişim Mesajları</h2>

                <?php if(isset($_GET['mesaj'])): ?>
                <div class="alert alert-success">
                    <?php
                    $mesaj = $_GET['mesaj'];
                    switch($mesaj) {
                        case 'okundu':
                            echo "Mesaj okundu olarak işaretlendi.";
                            break;
                        case 'silindi':
                            echo "Mesaj başarıyla silindi.";
                            break;
                    }
                    ?>
                </div>
                <?php endif; ?>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Ad Soyad</th>
                                <th>E-posta</th>
                                <th>Telefon</th>
                                <th>Mesaj</th>
                                <th>Tarih</th>
                                <th>Durum</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($row = mysqli_fetch_assoc($result)): ?>
                            <tr class="<?php echo $row['okundu'] ? '' : 'unread'; ?>">
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo $row['ad_soyad']; ?></td>
                                <td>
                                    <a href="mailto:<?php echo $row['email']; ?>">
                                        <?php echo $row['email']; ?>
                                    </a>
                                </td>
                                <td>
                                    <?php if($row['telefon']): ?>
                                    <a href="tel:<?php echo $row['telefon']; ?>">
                                        <?php echo $row['telefon']; ?>
                                    </a>
                                    <?php else: ?>
                                    <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo mb_substr($row['mesaj'], 0, 50) . '...'; ?></td>
                                <td><?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></td>
                                <td>
                                    <?php if($row['okundu']): ?>
                                    <span class="badge badge-success">Okundu</span>
                                    <?php else: ?>
                                    <span class="badge badge-warning">Okunmadı</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#mesajModal<?php echo $row['id']; ?>">
                                        <i class="fas fa-eye"></i> Görüntüle
                                    </button>
                                    <?php if(!$row['okundu']): ?>
                                    <a href="iletisim.php?okundu=<?php echo $row['id']; ?>" class="btn btn-sm btn-success">
                                        <i class="fas fa-check"></i> Okundu
                                    </a>
                                    <?php endif; ?>
                                    <a href="iletisim.php?sil=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu mesajı silmek istediğinizden emin misiniz?')">
                                        <i class="fas fa-trash"></i> Sil
                                    </a>
                                </td>
                            </tr>

                            <!-- Mesaj Detay Modal -->
                            <div class="modal fade" id="mesajModal<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="mesajModalLabel<?php echo $row['id']; ?>" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="mesajModalLabel<?php echo $row['id']; ?>">Mesaj Detayı</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <p><strong>Ad Soyad:</strong> <?php echo $row['ad_soyad']; ?></p>
                                            <p><strong>E-posta:</strong> <?php echo $row['email']; ?></p>
                                            <p><strong>Telefon:</strong> <?php echo $row['telefon'] ?: '-'; ?></p>
                                            <p><strong>Tarih:</strong> <?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></p>
                                            <hr>
                                            <p><strong>Mesaj:</strong></p>
                                            <p><?php echo nl2br($row['mesaj']); ?></p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
                                            <?php if(!$row['okundu']): ?>
                                            <a href="iletisim.php?okundu=<?php echo $row['id']; ?>" class="btn btn-success">
                                                <i class="fas fa-check"></i> Okundu Olarak İşaretle
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($total_pages > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if($sayfa > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa-1; ?>">&laquo; Önceki</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                            <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if($sayfa < $total_pages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa+1; ?>">Sonraki &raquo;</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html> 