<?php
require_once '../config.php';
checkLogin();

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $baslik = $_POST['baslik'];
    $icerik = $_POST['icerik'];
    $slug = createSlug($baslik);
    
    // Dosya yükleme
    $dosya = '';
    if(isset($_FILES['dosya']) && $_FILES['dosya']['error'] == 0) {
        $allowed = array('pdf', 'doc', 'docx');
        $filename = $_FILES['dosya']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if(in_array($ext, $allowed)) {
            $newname = uniqid() . '.' . $ext;
            
            // İçtihat klasörü yoksa oluştur
            if(!file_exists('../uploads/ictihat')) {
                mkdir('../uploads/ictihat', 0777, true);
            }
            
            $target = '../uploads/ictihat/' . $newname;
            
            if(move_uploaded_file($_FILES['dosya']['tmp_name'], $target)) {
                $dosya = $newname;
            }
        }
    }
    
    $sql = "INSERT INTO ictihat (baslik, icerik, dosya, slug) VALUES (?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "ssss", $baslik, $icerik, $dosya, $slug);
    
    if(mysqli_stmt_execute($stmt)) {
        header("Location: ictihat.php?mesaj=eklendi");
        exit;
    }
}

// Slug oluşturma fonksiyonu
function createSlug($str) {
    $str = mb_strtolower($str, 'UTF-8');
    $str = str_replace(
        ['ı', 'ğ', 'ü', 'ş', 'ö', 'ç'],
        ['i', 'g', 'u', 's', 'o', 'c'],
        $str
    );
    $str = preg_replace('/[^a-z0-9]/', '-', $str);
    $str = preg_replace('/-+/', '-', $str);
    return trim($str, '-');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yeni İçtihat Ekle - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Yeni İçtihat Ekle</h2>
                    <a href="ictihat.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Geri Dön
                    </a>
                </div>

                <form action="" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="baslik">Başlık</label>
                        <input type="text" class="form-control" id="baslik" name="baslik" required>
                    </div>

                    <div class="form-group">
                        <label for="icerik">İçerik</label>
                        <textarea class="form-control" id="icerik" name="icerik" required></textarea>
                    </div>

                    <div class="form-group">
                        <label for="dosya">Dosya (PDF, DOC, DOCX)</label>
                        <input type="file" class="form-control-file" id="dosya" name="dosya" accept=".pdf,.doc,.docx">
                        <small class="form-text text-muted">Maksimum dosya boyutu: 10MB</small>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Kaydet
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script>
        $(document).ready(function() {
            // Summernote editor'ı başlat
            $('#icerik').summernote({
                height: 300,
                lang: 'tr-TR',
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link']],
                    ['view', ['fullscreen', 'codeview']]
                ]
            });
        });
    </script>
</body>
</html> 