<?php
require_once '../config.php';
checkLogin();

// Silme işlemi
if(isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $id = $_GET['sil'];
    
    // Önce resmi sil
    $sql = "SELECT resim FROM galeri WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    
    if($row['resim']) {
        @unlink('../uploads/galeri/' . $row['resim']);
    }
    
    // Kaydı sil
    $sql = "DELETE FROM galeri WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: galeri.php?mesaj=silindi");
    exit;
}

// Sayfalama
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 12;
$offset = ($sayfa - 1) * $limit;

// Toplam resim sayısı
$total_sql = "SELECT COUNT(*) as total FROM galeri";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_assoc($total_result);
$total_galeri = $total_row['total'];
$total_pages = ceil($total_galeri / $limit);

// Resimleri getir
$sql = "SELECT * FROM galeri ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "ii", $limit, $offset);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galeri - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
        .gallery-item {
            position: relative;
            margin-bottom: 30px;
        }
        .gallery-item img {
            width: 100%;
            height: 200px;
            object-fit: cover;
            border-radius: 4px;
        }
        .gallery-item .overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.7);
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.3s;
            border-radius: 4px;
        }
        .gallery-item:hover .overlay {
            opacity: 1;
        }
        .gallery-item .actions {
            display: flex;
            gap: 10px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Galeri</h2>
                    <a href="galeri-ekle.php" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Yeni Resim Ekle
                    </a>
                </div>

                <?php if(isset($_GET['mesaj'])): ?>
                <div class="alert alert-success">
                    <?php
                    $mesaj = $_GET['mesaj'];
                    switch($mesaj) {
                        case 'eklendi':
                            echo "Resim başarıyla eklendi.";
                            break;
                        case 'guncellendi':
                            echo "Resim başarıyla güncellendi.";
                            break;
                        case 'silindi':
                            echo "Resim başarıyla silindi.";
                            break;
                    }
                    ?>
                </div>
                <?php endif; ?>

                <div class="row">
                    <?php while($row = mysqli_fetch_assoc($result)): ?>
                    <div class="col-md-3">
                        <div class="gallery-item">
                            <img src="../uploads/galeri/<?php echo $row['resim']; ?>" alt="<?php echo $row['baslik']; ?>">
                            <div class="overlay">
                                <div class="actions">
                                    <a href="galeri-duzenle.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-edit"></i> Düzenle
                                    </a>
                                    <a href="galeri.php?sil=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu resmi silmek istediğinizden emin misiniz?')">
                                        <i class="fas fa-trash"></i> Sil
                                    </a>
                                </div>
                            </div>
                            <div class="mt-2">
                                <h6 class="mb-0"><?php echo $row['baslik']; ?></h6>
                                <small class="text-muted"><?php echo date('d.m.Y', strtotime($row['created_at'])); ?></small>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>

                <?php if($total_pages > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if($sayfa > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa-1; ?>">&laquo; Önceki</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                            <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if($sayfa < $total_pages): ?>
                        <li class="page-item">
                            <a class="page-link" href="?sayfa=<?php echo $sayfa+1; ?>">Sonraki &raquo;</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html> 