<?php
require_once '../config.php';
checkLogin();

if(!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: galeri.php");
    exit;
}

$id = $_GET['id'];

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $baslik = $_POST['baslik'];
    
    // Resim yükleme
    $resim_sql = '';
    if(isset($_FILES['resim']) && $_FILES['resim']['error'] == 0) {
        $allowed = array('jpg', 'jpeg', 'png', 'gif');
        $filename = $_FILES['resim']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if(in_array($ext, $allowed)) {
            $newname = uniqid() . '.' . $ext;
            
            // Galeri klasörü yoksa oluştur
            if(!file_exists('../uploads/galeri')) {
                mkdir('../uploads/galeri', 0777, true);
            }
            
            $target = '../uploads/galeri/' . $newname;
            
            if(move_uploaded_file($_FILES['resim']['tmp_name'], $target)) {
                // Eski resmi sil
                $sql = "SELECT resim FROM galeri WHERE id = ?";
                $stmt = mysqli_prepare($conn, $sql);
                mysqli_stmt_bind_param($stmt, "i", $id);
                mysqli_stmt_execute($stmt);
                $result = mysqli_stmt_get_result($stmt);
                $row = mysqli_fetch_assoc($result);
                
                if($row['resim']) {
                    @unlink('../uploads/galeri/' . $row['resim']);
                }
                
                $resim_sql = ", resim = '$newname'";
            }
        }
    }
    
    $sql = "UPDATE galeri SET baslik = ? $resim_sql WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "si", $baslik, $id);
    
    if(mysqli_stmt_execute($stmt)) {
        header("Location: galeri.php?mesaj=guncellendi");
        exit;
    }
}

// Resmi getir
$sql = "SELECT * FROM galeri WHERE id = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "i", $id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$galeri = mysqli_fetch_assoc($result);

if(!$galeri) {
    header("Location: galeri.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resim Düzenle - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
        .image-preview {
            max-width: 300px;
            margin-top: 10px;
        }
        .image-preview img {
            width: 100%;
            height: auto;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Resim Düzenle</h2>
                    <a href="galeri.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Geri Dön
                    </a>
                </div>

                <form action="" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="baslik">Başlık</label>
                        <input type="text" class="form-control" id="baslik" name="baslik" value="<?php echo htmlspecialchars($galeri['baslik']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="resim">Resim</label>
                        <input type="file" class="form-control-file" id="resim" name="resim" accept="image/*">
                        <small class="form-text text-muted">İzin verilen formatlar: JPG, JPEG, PNG, GIF</small>
                        <?php if($galeri['resim']): ?>
                        <div class="image-preview mt-2">
                            <img src="../uploads/galeri/<?php echo $galeri['resim']; ?>" class="img-thumbnail">
                        </div>
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Kaydet
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        // Resim önizleme
        document.getElementById('resim').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if(file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const preview = document.querySelector('.image-preview');
                    preview.innerHTML = `<img src="${e.target.result}" class="img-thumbnail">`;
                }
                reader.readAsDataURL(file);
            }
        });
    </script>
</body>
</html> 