<?php
require_once '../config.php';
check_admin();

// Silme işlemi
if (isset($_GET['sil']) && !empty($_GET['sil'])) {
    $id = intval($_GET['sil']);
    $db->query("DELETE FROM calisma_alanlari WHERE id = $id");
    header('Location: calisma-alanlari.php?success=1');
    exit;
}

// Sayfalama
$sayfa = isset($_GET['sayfa']) ? intval($_GET['sayfa']) : 1;
$limit = 10;
$offset = ($sayfa - 1) * $limit;

// Toplam kayıt sayısı
$total = $db->query("SELECT COUNT(*) as total FROM calisma_alanlari")->fetch_assoc()['total'];
$total_pages = ceil($total / $limit);

// Çalışma alanlarını getir
$query = "SELECT * FROM calisma_alanlari ORDER BY created_at DESC LIMIT $offset, $limit";
$result = $db->query($query);

$page_title = 'Çalışma Alanları Yönetimi';
include 'header.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">Çalışma Alanları</h1>
        <a href="calisma-alani-ekle.php" class="btn btn-primary">
            <i class="fas fa-plus"></i> Yeni Ekle
        </a>
    </div>

    <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        İşlem başarıyla tamamlandı.
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>İkon</th>
                            <th>Başlık</th>
                            <th>Açıklama</th>
                            <th>Oluşturulma Tarihi</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><i class="<?php echo $row['ikon']; ?>"></i></td>
                            <td><?php echo $row['baslik']; ?></td>
                            <td><?php echo mb_substr($row['aciklama'], 0, 100) . '...'; ?></td>
                            <td><?php echo date('d.m.Y H:i', strtotime($row['created_at'])); ?></td>
                            <td>
                                <a href="calisma-alani-duzenle.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="?sil=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu çalışma alanını silmek istediğinize emin misiniz?')">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

            <?php if ($total_pages > 1): ?>
            <nav class="mt-4">
                <ul class="pagination justify-content-center">
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                        <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                    <?php endfor; ?>
                </ul>
            </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?> 