<?php
require_once '../config.php';
check_admin();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $baslik = $db->real_escape_string($_POST['baslik']);
    $slug = createSlug($baslik);
    $ikon = $db->real_escape_string($_POST['ikon']);
    $aciklama = $db->real_escape_string($_POST['aciklama']);
    $detay = $db->real_escape_string($_POST['detay']);
    $alt_basliklar = $db->real_escape_string($_POST['alt_basliklar']);

    $query = "INSERT INTO calisma_alanlari (baslik, slug, ikon, aciklama, detay, alt_basliklar) 
              VALUES ('$baslik', '$slug', '$ikon', '$aciklama', '$detay', '$alt_basliklar')";

    if ($db->query($query)) {
        header('Location: calisma-alanlari.php?success=1');
        exit;
    }
}

$page_title = 'Yeni Çalışma Alanı Ekle';
include 'header.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">Yeni Çalışma Alanı Ekle</h1>
        <a href="calisma-alanlari.php" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Geri Dön
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="" method="post">
                <div class="mb-3">
                    <label for="baslik" class="form-label">Başlık</label>
                    <input type="text" class="form-control" id="baslik" name="baslik" required>
                </div>

                <div class="mb-3">
                    <label for="ikon" class="form-label">Font Awesome İkon Sınıfı</label>
                    <input type="text" class="form-control" id="ikon" name="ikon" placeholder="Örn: fas fa-balance-scale" required>
                    <div class="form-text">Font Awesome ikonlarını <a href="https://fontawesome.com/icons" target="_blank">buradan</a> seçebilirsiniz.</div>
                </div>

                <div class="mb-3">
                    <label for="aciklama" class="form-label">Kısa Açıklama</label>
                    <textarea class="form-control" id="aciklama" name="aciklama" rows="3" required></textarea>
                </div>

                <div class="mb-3">
                    <label for="detay" class="form-label">Detaylı Açıklama</label>
                    <textarea class="form-control editor" id="detay" name="detay" rows="10" required></textarea>
                </div>

                <div class="mb-3">
                    <label for="alt_basliklar" class="form-label">Alt Başlıklar</label>
                    <textarea class="form-control" id="alt_basliklar" name="alt_basliklar" rows="5" required placeholder="Her satıra bir alt başlık yazın"></textarea>
                    <div class="form-text">Her satıra bir alt başlık gelecek şekilde yazın.</div>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // CKEditor'ü başlat
    CKEDITOR.replace('detay', {
        height: 400,
        removeButtons: 'Save,NewPage,Preview,Print,Templates,Cut,Copy,Paste,PasteText,PasteFromWord,Find,Replace,SelectAll,Scayt,Form,Checkbox,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,Strike,Subscript,Superscript,CopyFormatting,RemoveFormat,Outdent,Indent,CreateDiv,BidiLtr,BidiRtl,Language,Anchor,Flash,Table,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,Maximize,ShowBlocks,About'
    });
});
</script>

<?php include 'footer.php'; ?> 