<?php
require_once '../config.php';
checkLogin();

// Ayarları getir
$sql = "SELECT * FROM ayarlar WHERE id = 1";
$result = mysqli_query($conn, $sql);
$ayarlar = mysqli_fetch_assoc($result);

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $site_baslik = $_POST['site_baslik'];
    $site_aciklama = $_POST['site_aciklama'];
    $adres = $_POST['adres'];
    $telefon = $_POST['telefon'];
    $email = $_POST['email'];
    $facebook = $_POST['facebook'];
    $twitter = $_POST['twitter'];
    $instagram = $_POST['instagram'];
    $linkedin = $_POST['linkedin'];
    $calisma_saatleri = $_POST['calisma_saatleri'];
    $harita = $_POST['harita'];
    
    // Logo yükleme
    $logo_sql = '';
    if(isset($_FILES['logo']) && $_FILES['logo']['error'] == 0) {
        $allowed = array('jpg', 'jpeg', 'png', 'gif');
        $filename = $_FILES['logo']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if(in_array($ext, $allowed)) {
            $newname = 'logo.' . $ext;
            
            // Uploads klasörü yoksa oluştur
            if(!file_exists('../uploads')) {
                mkdir('../uploads', 0777, true);
            }
            
            $target = '../uploads/' . $newname;
            
            if(move_uploaded_file($_FILES['logo']['tmp_name'], $target)) {
                $logo_sql = ", logo = '$newname'";
            }
        }
    }
    
    // Favicon yükleme
    $favicon_sql = '';
    if(isset($_FILES['favicon']) && $_FILES['favicon']['error'] == 0) {
        $allowed = array('ico', 'png');
        $filename = $_FILES['favicon']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if(in_array($ext, $allowed)) {
            $newname = 'favicon.' . $ext;
            
            // Uploads klasörü yoksa oluştur
            if(!file_exists('../uploads')) {
                mkdir('../uploads', 0777, true);
            }
            
            $target = '../uploads/' . $newname;
            
            if(move_uploaded_file($_FILES['favicon']['tmp_name'], $target)) {
                $favicon_sql = ", favicon = '$newname'";
            }
        }
    }
    
    $sql = "UPDATE ayarlar SET 
            site_baslik = ?,
            site_aciklama = ?,
            adres = ?,
            telefon = ?,
            email = ?,
            facebook = ?,
            twitter = ?,
            instagram = ?,
            linkedin = ?,
            calisma_saatleri = ?,
            harita = ?
            $logo_sql
            $favicon_sql
            WHERE id = 1";
            
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "sssssssssss",
        $site_baslik,
        $site_aciklama,
        $adres,
        $telefon,
        $email,
        $facebook,
        $twitter,
        $instagram,
        $linkedin,
        $calisma_saatleri,
        $harita
    );
    
    if(mysqli_stmt_execute($stmt)) {
        header("Location: ayarlar.php?mesaj=guncellendi");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ayarlar - Admin Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .content {
            padding: 20px;
        }
        .preview-image {
            max-width: 200px;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include 'sidebar.php'; ?>
            
            <!-- Main Content -->
            <div class="col-md-10 content">
                <h2 class="mb-4">Ayarlar</h2>

                <?php if(isset($_GET['mesaj']) && $_GET['mesaj'] == 'guncellendi'): ?>
                <div class="alert alert-success">
                    Ayarlar başarıyla güncellendi.
                </div>
                <?php endif; ?>

                <form action="" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-6">
                            <h4 class="mb-3">Genel Ayarlar</h4>
                            
                            <div class="form-group">
                                <label for="site_baslik">Site Başlığı</label>
                                <input type="text" class="form-control" id="site_baslik" name="site_baslik" value="<?php echo htmlspecialchars($ayarlar['site_baslik']); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="site_aciklama">Site Açıklaması</label>
                                <textarea class="form-control" id="site_aciklama" name="site_aciklama" rows="3"><?php echo htmlspecialchars($ayarlar['site_aciklama']); ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="logo">Logo</label>
                                <input type="file" class="form-control-file" id="logo" name="logo" accept="image/*">
                                <?php if($ayarlar['logo']): ?>
                                <div class="preview-image">
                                    <img src="../uploads/<?php echo $ayarlar['logo']; ?>" alt="Logo" class="img-thumbnail">
                                </div>
                                <?php endif; ?>
                            </div>

                            <div class="form-group">
                                <label for="favicon">Favicon</label>
                                <input type="file" class="form-control-file" id="favicon" name="favicon" accept=".ico,.png">
                                <?php if($ayarlar['favicon']): ?>
                                <div class="preview-image">
                                    <img src="../uploads/<?php echo $ayarlar['favicon']; ?>" alt="Favicon" class="img-thumbnail">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <h4 class="mb-3">İletişim Bilgileri</h4>
                            
                            <div class="form-group">
                                <label for="adres">Adres</label>
                                <textarea class="form-control" id="adres" name="adres" rows="3"><?php echo htmlspecialchars($ayarlar['adres']); ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="telefon">Telefon</label>
                                <input type="text" class="form-control" id="telefon" name="telefon" value="<?php echo htmlspecialchars($ayarlar['telefon']); ?>">
                            </div>

                            <div class="form-group">
                                <label for="email">E-posta</label>
                                <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($ayarlar['email']); ?>">
                            </div>

                            <div class="form-group">
                                <label for="calisma_saatleri">Çalışma Saatleri</label>
                                <textarea class="form-control" id="calisma_saatleri" name="calisma_saatleri" rows="3"><?php echo htmlspecialchars($ayarlar['calisma_saatleri']); ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="harita">Google Harita Kodu</label>
                                <textarea class="form-control" id="harita" name="harita" rows="3"><?php echo htmlspecialchars($ayarlar['harita']); ?></textarea>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <h4 class="mb-3">Sosyal Medya</h4>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="facebook">Facebook</label>
                                        <input type="url" class="form-control" id="facebook" name="facebook" value="<?php echo htmlspecialchars($ayarlar['facebook']); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="twitter">Twitter</label>
                                        <input type="url" class="form-control" id="twitter" name="twitter" value="<?php echo htmlspecialchars($ayarlar['twitter']); ?>">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="instagram">Instagram</label>
                                        <input type="url" class="form-control" id="instagram" name="instagram" value="<?php echo htmlspecialchars($ayarlar['instagram']); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="linkedin">LinkedIn</label>
                                        <input type="url" class="form-control" id="linkedin" name="linkedin" value="<?php echo htmlspecialchars($ayarlar['linkedin']); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Kaydet
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        // Resim önizleme
        function previewImage(input, previewClass) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    var preview = input.parentElement.querySelector('.' + previewClass);
                    if (!preview) {
                        preview = document.createElement('div');
                        preview.className = previewClass;
                        input.parentElement.appendChild(preview);
                    }
                    preview.innerHTML = `<img src="${e.target.result}" class="img-thumbnail">`;
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        document.getElementById('logo').addEventListener('change', function() {
            previewImage(this, 'preview-image');
        });

        document.getElementById('favicon').addEventListener('change', function() {
            previewImage(this, 'preview-image');
        });
    </script>
</body>
</html> 